% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/censor.R
\name{ssd_censor_data}
\alias{ssd_censor_data}
\title{Censor Data}
\usage{
ssd_censor_data(data, left = "Conc", ..., right = left, censoring = c(0, Inf))
}
\arguments{
\item{data}{A data frame.}

\item{left}{A string of the column in data with the concentrations.}

\item{...}{Unused.}

\item{right}{A string of the column in data with the right concentration values.}

\item{censoring}{A numeric vector of the left and right censoring values.}
}
\value{
A tibble of the censored data.
}
\description{
Censors data to a specified range based on the \code{censoring} argument.
The function is useful for creating test data sets.
}
\examples{
ssd_censor_data(ssddata::ccme_boron, censoring = c(2.5, Inf))
}
