#' This class represents an SQL list.
#'
#' An abstract class to represent a list. Used by ExprListValues and
#' ExprListFields.
#'
#' @examples
#' # No example provided, as this class is abstract.
#'
#' @import R6
#' @include Expr.R
#' @include TokenSymbol.R
#' @export
ExprList <- R6::R6Class("ExprList",
  inherit = Expr,
  public = list(

    #' @description
    #' Initializer.
    #' @param expr A list of Expr instances.
    #' @return Nothing.
    initialize = function(expr) {
      chk::chk_all(expr, chk::chk_is, "Expr")
      private$lst_expr <- expr
      return(invisible(NULL))
    },

    #' @description
    #' Generates the list of tokens representing this statement.
    #' @return A list of Token objects.
    getTokens = function() {
      tokens <- list(.lparen)
      i <- 0L
      for (expr in private$lst_expr) {
        if (i > 0L) {
          tokens <- c(tokens, .coma, optspace())
        }
        tokens <- c(tokens, expr$getTokens())
        i <- i + 1L
      }
      tokens <- c(tokens, .rparen)
      return(tokens)
    }
  ),
  private = list(
    lst_expr = NULL
  )
)
