% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inspect.R
\name{inspect}
\alias{inspect}
\alias{inspect.data.frame}
\alias{inspect.occdat}
\alias{inspect.occkey}
\title{Get more data on individual occurrences}
\usage{
inspect(x, from = "gbif")

\method{inspect}{data.frame}(x, from = "gbif")

\method{inspect}{occdat}(x, from = "gbif")

\method{inspect}{occkey}(x, from = "gbif")
}
\arguments{
\item{x}{The output from \code{\link[=occ]{occ()}} call, output from call to
\code{\link[=occ2df]{occ2df()}}, or an occurrence ID as a occkey class.}

\item{from}{(character) The data provider. One of gbif, inat,
or vertnet}
}
\value{
A list, with each slot named for the data source, and then
within data sources is a slot for each taxon, named by it's occurrence ID.
}
\description{
Fetches the complete record, which may or may not be the same
as requested through \code{\link[=occ]{occ()}}. Some data providers have different ways
to retrieve many occurrence records vs. single occurrence records -
and sometimes the results are more verbose when retrieving a
single occurrence record.
}
\examples{
\dontrun{
spnames <- c('Accipiter striatus', 'Spinus tristis')
out <- occ(query=spnames, from=c('gbif','idigbio'),
   gbifopts=list(hasCoordinate=TRUE), limit=2)
res <- occ2df(out)
inspect(res)

out <- occ(query=spnames, from='gbif', gbifopts=list(hasCoordinate=TRUE),
  limit=4)
res <- occ2df(out)
inspect(res)

# from occkeys
key <- as.gbif(res$key[1])
inspect(key)

# idigbio
spnames <- c('Accipiter striatus', 'Spinus tristis')
out <- occ(query=spnames, from='idigbio', limit=20)
inspect(out)
}
}
