% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_training_df.R
\name{plot_training_df}
\alias{plot_training_df}
\title{Scatterplots of a training data frame}
\usage{
plot_training_df(
  data = NULL,
  dependent.variable.name = NULL,
  predictor.variable.names = NULL,
  ncol = 4,
  method = "loess",
  point.color = viridis::viridis(100, option = "F"),
  line.color = "gray30"
)
}
\arguments{
\item{data}{Data frame with a response variable and a set of predictors. Default: \code{NULL}}

\item{dependent.variable.name}{Character string with the name of the response variable. Must be in the column names of \code{data}. If the dependent variable is binary with values 1 and 0, the argument \code{case.weights} of \code{ranger} is populated by the function \code{\link[=case_weights]{case_weights()}}. Default: \code{NULL}}

\item{predictor.variable.names}{Character vector with the names of the predictive variables. Every element of this vector must be in the column names of \code{data}. Optionally, the result of \code{\link[=auto_cor]{auto_cor()}} or \code{\link[=auto_vif]{auto_vif()}} Default: \code{NULL}}

\item{ncol}{Number of columns of the plot. Argument \code{ncol} of \link[patchwork]{wrap_plots}.}

\item{method}{Method for \link[ggplot2]{geom_smooth}, one of: "lm", "glm", "gam", "loess", or a function, for example \code{mgcv::gam} Default: 'loess'}

\item{point.color}{Colors of the plotted points. Can be a single color name (e.g. "red4"), a character vector with hexadecimal codes (e.g. "#440154FF" "#21908CFF" "#FDE725FF"), or function generating a palette (e.g. \code{viridis::viridis(100)}). Default: \code{viridis::viridis(100, option = "F")}}

\item{line.color}{Character string, color of the line produced by \code{ggplot2::geom_smooth()}. Default: \code{"gray30"}}
}
\value{
A \link[patchwork]{wrap_plots} object.
}
\description{
Plots the dependent variable against each predictor.
}
\examples{

data(
  plants_df,
  plants_response,
  plants_predictors
)

plot_training_df(
  data = plants_df,
  dependent.variable.name = plants_response,
  predictor.variable.names = plants_predictors[1:4]
)

}
\seealso{
Other visualization: 
\code{\link{plot_evaluation}()},
\code{\link{plot_importance}()},
\code{\link{plot_moran}()},
\code{\link{plot_optimization}()},
\code{\link{plot_residuals_diagnostics}()},
\code{\link{plot_response_curves}()},
\code{\link{plot_response_surface}()},
\code{\link{plot_training_df_moran}()},
\code{\link{plot_tuning}()}
}
\concept{visualization}
