% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/change.R
\name{sourcoise_untrack}
\alias{sourcoise_untrack}
\title{Remove Tracking from Cached Files}
\usage{
sourcoise_untrack(path, root = getOption("sourcoise.root"))
}
\arguments{
\item{path}{Character string specifying the file path whose cache metadata
should be updated.}

\item{root}{Character string specifying the root directory for the cache.
Defaults to \code{getOption("sourcoise.root")}.}
}
\value{
Invisibly returns the results of writing metadata for each updated
cache entry. Returns a message string if no files are found or no tracked
files exist.
}
\description{
Removes tracking metadata from cached files associated with a given path by
setting the track field to an empty list.
}
\details{
NOte that tracked fies are accumulated when specified in \code{track} argument of \code{soucoise()}.
This function allows to reset the list.

The function locates all cache entries for the specified path, filters to
entries that currently have tracking enabled (non-empty priority field), and
removes tracking by setting the track field to an empty list. Only affects
the most recent cache entry for each argument hash.
}
\examples{
\dontrun{
# Remove tracking from cached results
sourcoise_untrack("scripts/analysis.R")
}
}
