% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stk_screen_twl.R
\name{stk_screen_twl}
\alias{stk_screen_twl}
\title{Twilight screening routine}
\usage{
stk_screen_twl(df, threshold = 1.5, dips = 3, step = 100, filter = TRUE)
}
\arguments{
\item{df}{A skytrackr data frame.}

\item{threshold}{A twilight threshold (default = 1.5).}

\item{dips}{The allowed number of interruptions during a daylight profile
below the twilight threshold before flagging as a poor quality "suspect"
day.}

\item{step}{A threshold of the allowed step change in illuminance values
between the twilight value and the preceding one. Large jumps and the lack
of a smooth transition suggest a false twilight (bird leaving a dark nest
site long after or long before dawn or dusk).}

\item{filter}{Logical if to return data pre-filtered, removing all poor quality days
or false twilight ones (default = TRUE)}
}
\value{
A skytrackr data frame with poor twilight quality days removed and
 dusk and dawn timings marked (data is returned as a long format, not a wide
 format).
}
\description{
Removes poor quality data based on twilight heuristics. Allows for quick
screening of data containing "false" twilight values.
}
\examples{

# set demo values artificially low as a demonstration
library(dplyr)
df <- cc876 |>
  mutate(
  value = ifelse(
    date_time > "2021-08-15 05:00:00" & date_time < "2021-08-15 12:00:00",
    0.1,
    value)
  )

# screen values and remove them (filter = TRUE)
df <- df |> stk_screen_twl(filter = TRUE)
}
