% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peaks.R
\name{dpeak}
\alias{dpeak}
\title{Probability mass function of number of peaks in an i.i.d. random sequence}
\usage{
dpeak(k, n, usedata = FALSE)
}
\arguments{
\item{k}{An integer or a sequence of integers strictly incrementing by 1,
with all values between 0 and \code{n - 1} inclusive. Represents the number
of peaks in the sequence.}

\item{n}{A positive integer representing the number of observations in the
sequence.}

\item{usedata}{A logical. Should probability mass function values be
read from \code{\link{dpeakdat}} rather than computing them? This option
will save significantly on computation time if \eqn{n < 170} but is
currently only available for \eqn{n \leq 1000}.}
}
\value{
A double between 0 and 1 representing the probability of exactly
k peaks occurring in a sequence of \eqn{n} independent and identically
distributed continuous random variables. The double has a \code{names}
attribute with the values corresponding to the probabilities.
Computation time is very slow for
\eqn{n > 170} (if \code{usedata} is \code{FALSE}) and for \eqn{n > 1000}
regardless of \code{usedata} value.
}
\description{
This function computes \eqn{P(n,k)} as defined by
\insertCite{Goldfeld65;textual}{skedastic}, i.e. the probability that a
sequence of \eqn{n} independent and identically distributed random variables
contains exactly \eqn{k} peaks, with peaks also as defined by
\insertCite{Goldfeld65;textual}{skedastic}. The function is used in
\code{\link{ppeak}} to compute \eqn{p}-values for the Goldfeld-Quandt
nonparametric test for heteroskedasticity in a linear model.
}
\examples{
dpeak(0:9, 10)
plot(0:9, dpeak(0:9, 10), type = "p", pch = 20, xlab = "Number of Peaks",
         ylab = "Probability")

# This would be extremely slow if usedata were set to FALSE:
prob <- dpeak(0:199, 200, usedata = TRUE)
plot(0:199, prob, type = "l", xlab = "Number of Peaks", ylab = "Probability")

# `dpeakdat` is a dataset containing probabilities generated from `dpeak`
utils::data(dpeakdat)
expval <- unlist(lapply(dpeakdat,
                 function(p) sum(p * 0:(length(p) - 1))))
plot(1:1000, expval[1:1000], type = "l", xlab = parse(text = "n"),
     ylab = "Expected Number of Peaks")
}
\references{
{\insertAllCited{}}
}
\seealso{
\code{\link{ppeak}}, \code{\link{goldfeld_quandt}}
}
