% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imu.r
\name{[.imu}
\alias{[.imu}
\title{Subset an IMU Object}
\usage{
\method{[}{imu}(x, i, j, drop = FALSE)
}
\arguments{
\item{x}{A \code{imu} object}

\item{i}{A \code{integer vector} that specifies the rows to subset. If blank, all rows are selected.}

\item{j}{A \code{integer vector} that specifies the columns to subset. Special rules apply see details.}

\item{drop}{A \code{boolean} indicating whether the structure should be preserved or simplified.}
}
\value{
An \code{imu} object class.
}
\description{
Enables the IMU object to be subsettable. That is, you can load all the data in and then select certain properties.
}
\details{
When using the subset operator, note that all the Gyroscopes are placed at the front of object 
and, then, the Accelerometers are placed.
}
\examples{
\dontrun{
if(!require("imudata")){
install_imudata()
library("imudata")
}

data(imu6)

# Create an IMU Object that is full. 
ex = imu(imu6, gyros = 1:3, accels = 4:6, axis = c('X', 'Y', 'Z', 'X', 'Y', 'Z'), freq = 100)

# Create an IMU object that has only gyros. 
ex.gyro = ex[,1:3]
ex.gyro2 = ex[,c("Gyro. X","Gyro. Y","Gyro. Z")]

# Create an IMU object that has only accels. 
ex.accel = ex[,4:6]
ex.accel2 = ex[,c("Accel. X","Accel. Y","Accel. Z")]

# Create an IMU object with both gyros and accels on axis X and Y
ex.b = ex[,c(1,2,4,5)]
ex.b2 = ex[,c("Gyro. X","Gyro. Y","Accel. X","Accel. Y")]

}

}
