% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{MRPModel}
\alias{MRPModel}
\title{MRPModel objects}
\arguments{
\item{model_spec}{List containing model effects specification, including intercept, fixed effects, varying effects, and interactions}

\item{mrp_data}{List containing the MRP data structure with input sample data and new poststratification data}

\item{metadata}{List containing metadata about the analysis, including family, time variables, and special cases}

\item{link_data}{List containing information about data linking, including geography and ACS year}

\item{plot_data}{List containing data prepared for visualization, including dates and GeoJSON objects}

\item{extra}{List containing COVID test sensitivity and specificity}
}
\value{
A new \code{MRPModel} object initialized with the provided model specification and relevant data.
}
\description{
An \code{MRPModel} object is an \link[R6:R6Class]{R6} object created by the
\code{\link[=MRPWorkflow-method-create_model]{$create_model()}} method of an
\code{\link{MRPWorkflow}} object. Each \code{MRPModel} object represents a
multilevel regression model, providing methods for sampling, diagnostics,
and poststratification.

Creates a new instance of the \code{MRPModel} class. This method is called by the \verb{$create_model()}
method of an \code{MRPWorkflow} object and does not need to be called directly by users.
}
\section{Methods}{
 \code{MRPModel} objects have the following associated
methods, many of which have their own (linked) documentation pages:
\subsection{Data access}{\tabular{ll}{
   \strong{Method} \tab \strong{Description} \cr
   \code{\link[=MRPModel-method-model_spec]{$model_spec()}} \tab Return model specification. \cr
   \code{\link[=MRPModel-method-formula]{$formula()}} \tab Return model formula. \cr
   \code{\link[=MRPModel-method-metadata]{$metadata()}} \tab Return model metadata. \cr
   \code{\link[=MRPModel-method-stan_code]{$stan_code()}} \tab Return model Stan code. \cr
}

}

\subsection{Model fitting}{\tabular{ll}{
   \strong{Method} \tab \strong{Description} \cr
   \code{\link[=MRPModel-method-fit]{$fit()}} \tab Fit multilevel regression model using CmdStanR. \cr
   \code{\link[=MRPModel-method-check_fit_exists]{$check_fit_exists()}} \tab Check if model has been fitted. \cr
   \code{\link[=MRPModel-method-check_estimate_exists]{$check_estimate_exists()}} \tab Check if poststratification has been performed. \cr
}

}

\subsection{Posterior summary & diagnostics}{\tabular{ll}{
   \strong{Method} \tab \strong{Description} \cr
   \code{\link[=MRPModel-method-summary]{$summary()}} \tab Return posterior summary table. \cr
   \code{\link[=MRPModel-method-diagnostics]{$diagnostics()}} \tab Return sampling diagnostics. \cr
}

}

\subsection{Post-processing}{\tabular{ll}{
   \strong{Method} \tab \strong{Description} \cr
   \code{\link[=MRPModel-method-ppc]{$ppc()}} \tab Create input for posterior predictive check. \cr
   \code{\link[=MRPModel-method-log_lik]{$log_lik()}} \tab Create input for leave-one-out cross-validation. \cr
   \code{\link[=MRPModel-method-poststratify]{$poststratify()}} \tab Run poststratification to generate population estimates. \cr
}

}

\subsection{Saving model object}{\tabular{ll}{
   \strong{Method} \tab \strong{Description} \cr
   \code{\link[=MRPModel-method-save]{$save()}} \tab Save model object to file. \cr
}

}
}

\examples{
\dontshow{if (requireNamespace("cmdstanr", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
 \donttest{
   library(shinymrp)

   # Initialize workflow
   workflow <- mrp_workflow()

   # Load example data
   sample_data <- example_sample_data()

   # Preprocess sample data
   workflow$preprocess(
     sample_data,
     is_timevar = TRUE,
     is_aggregated = TRUE,
     special_case = NULL,
     family = "binomial"
   )

   # Link to ACS data at ZIP code level
   workflow$link_acs(
     link_geo = "zip",
     acs_year = 2021
   )

   # Create and fit multiple models
   model <- workflow$create_model(
     intercept_prior = "normal(0, 4)",
     fixed = list(
       sex = "normal(0, 2)"
     ),
     varying = list(
       race = "normal(0, 2)",
       age = "normal(0, 2)",
       time = "normal(0, 2)"
     )
   )

   # Run MCMC
   model$fit(n_iter = 500, n_chains = 2, seed = 123)

   # Estimates summary and diagnostics
   posterior_summary <- model$summary()

   # Sampling diagnostics
   model_diagnostics <- model$diagnostics()
 }
\dontshow{\}) # examplesIf}
}
