% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monacoEditor.R
\name{monacoEditor}
\alias{monacoEditor}
\title{Render an monaco editor}
\usage{
monacoEditor(
  value,
  fontFamily = "Consolas",
  fontSize = 16,
  insertSpaces = TRUE,
  language = "plaintext",
  lineNumbers = "on",
  placeholder = NULL,
  readOnly = FALSE,
  renderWhitespace = "boundary",
  rulers = list(80, 100, 120),
  scrollBeyondLastLine = TRUE,
  showStatusBar = TRUE,
  tabSize = 4,
  theme = "vs",
  wordWrap = "off",
  automaticLayout = TRUE,
  ...,
  width = NULL,
  height = NULL,
  elementId = NULL
)
}
\arguments{
\item{value}{\link{character}: Set text to editor when initializing}

\item{fontFamily}{\link{character}: The font family}

\item{fontSize}{\link{integer}: The font size}

\item{insertSpaces}{\link{logical}: Insert spaces when pressing Tab. This setting is overridden based on the file contents when detectIndentation is on. Defaults to true.}

\item{language}{\link{character}: The initial language of the auto created model in the editor. To not automatically create a model, use model: null.}

\item{lineNumbers}{\link{character}, \link{integer}: Control the rendering of line numbers. If it is a function, it will be invoked when rendering a line number and the return value will be rendered. Otherwise, if it is a truthy, line numbers will be rendered normally (equivalent of using an identity function). Otherwise, line numbers will not be rendered. Defaults to on.}

\item{placeholder}{\link{character}: Sets a placeholder for the editor. If set, the placeholder is shown if the editor is empty.}

\item{readOnly}{\link{logical}: Should the editor be read only. See also domReadOnly. Defaults to false.}

\item{renderWhitespace}{\link{character}: Enable rendering of whitespace. Defaults to 'selection'. Valid values: "all" | "none" | "boundary" | "selection" | "trailing"}

\item{rulers}{\link{list}: Render vertical lines at the specified columns. Defaults to empty list.}

\item{scrollBeyondLastLine}{\link{logical}: Enable that scrolling can go one screen size after the last line. Defaults to true.}

\item{showStatusBar}{\link{logical}: Show statusBar}

\item{tabSize}{\link{integer}: The number of spaces a tab is equal to. This setting is overridden based on the file contents when detectIndentation is on. Defaults to 4.}

\item{theme}{\link{character}: Initial theme to be used for rendering. The current out-of-the-box available themes are: 'vs' (default), 'vs-dark', 'hc-black', 'hc-light. You can create custom themes via monaco.editor.defineTheme. To switch a theme, use monaco.editor.setTheme. NOTE: The theme might be overwritten if the OS is in high contrast mode, unless autoDetectHighContrast is set to false.}

\item{wordWrap}{\link{character}: Control the wrapping of the editor. When wordWrap = "off", the lines will never wrap. When wordWrap = "on", the lines will wrap at the viewport width. When wordWrap = "wordWrapColumn", the lines will wrap at wordWrapColumn. When wordWrap = "bounded", the lines will wrap at min(viewport width, wordWrapColumn). Defaults to "off".
Valid values: "off" | "on" | "wordWrapColumn" | "bounded"}

\item{automaticLayout}{\link{logical}: Enable that the editor will install a ResizeObserver to check if its container dom node size has changed. Defaults to TRUE.}

\item{...}{For more arguments, please refer to \url{https://microsoft.github.io/monaco-editor/docs.html#interfaces/editor_editor_api.editor.IStandaloneEditorConstructionOptions.html}}

\item{width}{\link{integer}, \link{character}: Width in pixels (optional, defaults to automatic sizing)}

\item{height}{\link{integer}, \link{character}: Height in pixels (optional, defaults to automatic sizing)}

\item{elementId}{\link{character}: An element id for the widget (a random character by default)}
}
\value{
Widget for shiny application
}
\description{
Render an Monaco editor on an application page.
}
\examples{
if(interactive()){
    shinyEditor::monacoEditor(value = "text")
}
}
