% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{dimnames<-.shapviz}
\alias{dimnames<-.shapviz}
\title{Dimnames (Replacement Method) of "shapviz" Object}
\usage{
\method{dimnames}{shapviz}(x) <- value
}
\arguments{
\item{x}{An object of class "shapviz".}

\item{value}{A list with rownames and column names compliant with SHAP matrix.}
}
\value{
Like \code{x}, but with replaced dimnames.
}
\description{
This implies \code{colnames(x) <- ...}.
}
\examples{
S <- matrix(c(1, -1, -1, 1), ncol = 2, dimnames = list(NULL, c("x", "y")))
X <- data.frame(x = c("a", "b"), y = c(100, 10))
x <- shapviz(S, X, baseline = 4)
dimnames(x) <- list(1:2, c("a", "b"))
dimnames(x)
colnames(x) <- c("x", "y")
colnames(x)
}
\seealso{
\code{\link[=shapviz]{shapviz()}}
}
