% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shapley_setup.R
\name{create_coalition_table}
\alias{create_coalition_table}
\title{Define coalitions, and fetch additional information about each unique coalition}
\usage{
create_coalition_table(
  m,
  exact = TRUE,
  n_coalitions = 200,
  n_coal_each_size = choose(m, seq(m - 1)),
  weight_zero_m = 10^6,
  paired_shap_sampling = TRUE,
  prev_X = NULL,
  n_samps_scale = 10,
  coal_feature_list = as.list(seq_len(m)),
  approach0 = "gaussian",
  kernelSHAP_reweighting = "none",
  semi_deterministic_sampling = FALSE,
  dt_coal_samp_info = NULL,
  dt_valid_causal_coalitions = NULL
)
}
\arguments{
\item{m}{Positive integer.
Total number of features/groups.}

\item{exact}{Logical.
If \code{TRUE} all \code{2^m} coalitions are generated, otherwise a subsample of the coalitions is used.}

\item{n_coalitions}{Positive integer.
Note that if \code{exact = TRUE}, \code{n_coalitions} is ignored.}

\item{n_coal_each_size}{Vector of integers of length \code{m-1}. The number of valid coalitions of each coalition size
1, 2,..., m-1. For symmetric Shapley values, this is \code{choose(m, seq(m-1))} (default). While for asymmetric Shapley
values, this is the number of valid coalitions of each size in the causal ordering. Used to correctly normalize the
Shapley weights.}

\item{weight_zero_m}{Numeric.
The value to use as a replacement for infinite coalition weights when doing numerical operations.}

\item{paired_shap_sampling}{Logical.
Whether to do paired sampling of coalitions.}

\item{prev_X}{data.table. The X data.table from the previous iteration.}

\item{n_samps_scale}{Positive integer.
Integer that scales the number of coalitions \code{n_coalitions} to sample as sampling is cheap,
while checking for \code{n_coalitions} unique coalitions is expensive, thus we over sample the
number of coalitions by a factor of \code{n_samps_scale} and determine when we have \code{n_coalitions} unique
coalitions and only use the coalitions up to this point and throw away the remaining coalitions.}

\item{coal_feature_list}{List.
A list mapping each coalition to the features it contains.}

\item{approach0}{Character vector.
Contains the approach to be used for estimation of each coalition size. Same as \code{approach} in \code{\link[=explain]{explain()}}.}

\item{kernelSHAP_reweighting}{String.
How to reweight the sampling frequency weights in the kernelSHAP solution after sampling.
The aim of this is to reduce the randomness and thereby the variance of the Shapley value estimates.
The options are one of \code{'none'}, \code{'on_N'}, \code{'on_all'}, \code{'on_all_cond'} (default).
\code{'none'} means no reweighting, i.e. the sampling frequency weights are used as is.
\code{'on_N'} means the sampling frequencies are averaged over all coalitions with the same original sampling
probabilities.
\code{'on_all'} means the original sampling probabilities are used for all coalitions.
\code{'on_all_cond'} means the original sampling probabilities are used for all coalitions, while adjusting for the
probability that they are sampled at least once.
\code{'on_all_cond'} is preferred as it performs the best in simulation studies, see
\href{https://link.springer.com/content/pdf/10.1007/978-3-032-08324-1_9.pdf}{Olsen & Jullum (2025)}.}

\item{semi_deterministic_sampling}{Logical.
If \code{FALSE} (default), then we sample from all coalitions.
If \code{TRUE}, the sampling of coalitions is semi-deterministic, i.e. the sampling is done in a way that ensures that
coalitions that are expected to be sampled based on the number of coalitions are deterministically included such
that we sample among fewer coalitions. This is done to reduce the variance of the Shapley value estimates,
and corresponds to the PySHAP* strategy in the paper
\href{https://link.springer.com/content/pdf/10.1007/978-3-032-08324-1_9.pdf}{Olsen & Jullum (2025)}.}

\item{dt_coal_samp_info}{data.table. The data.table contains information about which coalitions should be
deterministically included and which can be sampled, in addition to the sampling probabilities of each available
coalition size, and the weight given to the sampled and deterministically included coalitions (excluding empty and
grand coalitions which are given the \code{weight_zero_m} weight).}

\item{dt_valid_causal_coalitions}{data.table. Only applicable for asymmetric Shapley
value explanations, and is \code{NULL} for symmetric Shapley values.
The data.table contains information about the coalitions that respects the causal ordering.}
}
\value{
A data.table with info about the coalitions to use
}
\description{
Define coalitions, and fetch additional information about each unique coalition
}
\author{
Nikolai Sellereite, Martin Jullum, Lars Henry Berge Olsen
}
\keyword{internal}
