% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sf.R
\name{sf_linestring}
\alias{sf_linestring}
\title{sf LINESTRING}
\usage{
sf_linestring(
  obj = NULL,
  x = NULL,
  y = NULL,
  z = NULL,
  m = NULL,
  linestring_id = NULL,
  keep = FALSE,
  list_columns = NULL
)
}
\arguments{
\item{obj}{sorted matrix or data.frame}

\item{x}{x geometry column}

\item{y}{y geometry column}

\item{z}{z geometry column}

\item{m}{m geometry column}

\item{linestring_id}{column of ids for linestrings}

\item{keep}{logical indicating if the non-geometry and non-id columns should be kept.
if TRUE you must supply the geometry and id columns, and only the first row of
each geometry is kept. See Keeping Properties.}

\item{list_columns}{vector of column names to turn into a list.}
}
\value{
\code{sf} object of LINESTRING geometries
}
\description{
constructs sf of LINESTRING objects
}
\section{notes}{

sfheaders functions do not perform any validity checks on the geometries.
Nor do they set Coordinate Reference Systems, EPSG, PROJ4 or precision attributes.

The data.frame and matrices you send into the sfheader functions must be ordered.
}

\section{Keeping Properties}{


Setting \code{keep = TRUE} will retain any columns not specified as a
coordinate (x, y, z, m) or an id (e.g., linestring_id, polygon_id) of the input \code{obj}.

You can use \code{list_columns} to specify which of the properties will be turned into
a list, thus keeping all the values in the column. For columns not specified in \code{list_columns},
only the first row of the column is kept

The \code{sf_*} functions assume the input \code{obj} is a long data.frame / matrix,
where any properties are repeated down the table for the same geometry.
}

\examples{

x <- matrix( c(1:8), ncol = 2 )
sf_linestring( x )

x <- cbind( x, c(1,1,2,2) )
sf_linestring( obj = x, x = 1, y = 2 )
sf_linestring( obj = x, x = 1, y = 2, linestring_id = 3 )

x <- data.frame( line_id = 1:2, x = 1:2, y = 2:1 )
sf_linestring( x )
sf_linestring( x, x = "x", y = "y" )
sf_linestring( x, x = "y", y = "x" )
sf_linestring( x, linestring_id = "line_id", x = "x", y = "y")

## keeping properties
x <- data.frame(
  line_id = c(1,1,2,2)
  , x = 1:4
  , y = 4:1
  , val = letters[1:4]
  , stringsAsFactors = FALSE
  )

## first-row of 'val' is kept
sf_linestring( x, x = "x", y = "y", keep = TRUE )
sf_linestring( x, linestring_id = "line_id", x = "x", y = "y", keep = TRUE )

## 'val' column converted to a list
sf_linestring( x, linestring_id = "id", x = "x", y = "y", keep = TRUE, list_columns = "val" )


}
