% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_api_diagnostics.R
\name{st_api_diagnostics}
\alias{st_api_diagnostics}
\title{Diagnose API Issues}
\usage{
st_api_diagnostics(
  app_id,
  verbose = TRUE,
  auth_token = Sys.getenv("SENSORTOWER_AUTH_TOKEN")
)
}
\arguments{
\item{app_id}{Character string. The app ID to diagnose (can be unified, iOS, or Android)}

\item{verbose}{Logical. Show detailed diagnostic output. Default is TRUE.}

\item{auth_token}{Character string. Your Sensor Tower API authentication token.}
}
\value{
A list with diagnostic results including:
  - `id_type`: Detected ID type
  - `platform_ids`: Resolved platform-specific IDs
  - `endpoint_results`: Results from testing various endpoints
  - `recommendations`: Suggested approach for this app
}
\description{
This function helps diagnose common API issues by testing various ID formats
and endpoints to determine the best approach for fetching data.
}
\examples{
\dontrun{
# Diagnose Star Trek Fleet Command
diagnosis <- st_api_diagnostics("5ba4585f539ce75b97db6bcb")

# Check iOS app
diagnosis <- st_api_diagnostics("1427744264")
}

}
