% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write-doc-audit.R
\name{write_doc_audit_total_n}
\alias{write_doc_audit_total_n}
\title{Documentation template for \code{\link[=audit_total_n]{audit_total_n()}}}
\usage{
write_doc_audit_total_n(key_args, name_test)
}
\arguments{
\item{key_args}{String vector with the names of the key columns that are
tested for consistency by the \verb{*_map_seq()} function. (These are the
original variable names, without \code{"1"} and \code{"2"} suffixes.) The values need
to have the same order as in that function's output.}

\item{name_test}{String (length 1). Name of the consistency test which the
\verb{*_map_seq()} function applies, such as \code{"GRIM"}.}
}
\value{
A string vector formatted by \code{\link[glue:glue]{glue::glue()}}.
}
\description{
\code{write_doc_audit_total_n()} creates a roxygen2 block section to
be inserted into the documentation of functions created with
\code{\link[=function_map_total_n]{function_map_total_n()}}. The section informs users about the ways in
which \code{\link[=audit_seq]{audit_seq()}} summarizes the results of the manufactured
\verb{*_map_total_n()} function.

Copy the output from your console and paste it into the roxygen2 block of
your \verb{*_map_total_n()} function. To preserve the bullet-point structure
when indenting roxygen2 comments with \code{Ctrl}+\code{Shift}+\code{/}, leave empty lines
between the pasted output and the rest of the block.
}
\examples{
# For GRIM and `grim_map_total_n()`:
write_doc_audit_total_n(key_args = c("x", "n"), name_test = "GRIM")

# For DEBIT and `debit_map_total_n()`:
write_doc_audit_total_n(key_args = c("x", "sd", "n"), name_test = "DEBIT")
}
\seealso{
The sister function \code{\link[=write_doc_audit_seq]{write_doc_audit_seq()}} and, for context,
\code{vignette("consistency-tests-in-depth")}.
}
