% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_legend.R
\name{add_legend}
\alias{add_legend}
\title{Add a legend to an scplot}
\usage{
add_legend(
  object,
  labels = NULL,
  section_labels = c("Lines", "Phases"),
  case = 1,
  position = "right",
  datalines = TRUE,
  statlines = TRUE,
  phases = TRUE,
  title = NULL,
  text = NULL,
  background = NULL
)
}
\arguments{
\item{object}{An scplot object (class \code{scplot}) returned from the \code{scplot()}
function.}

\item{labels}{A Character vector with text labels.}

\item{section_labels}{A character vector of length two. The labels for the
lines section and phase section.}

\item{case}{Numerical vector with the case number or character string. \code{case = "all"} for all cases.}

\item{position}{The position ("none", "left", "right", "bottom", "top", or
two-element numeric vector)}

\item{datalines}{If TRUE, a legend for the datalines is generated.}

\item{statlines}{If TRUE, a legend for the statlines is generated.}

\item{phases}{If TRUE, a legend for the phases is generated.
Note that you also have to set the \code{set_panel} argument
(e.g., \code{set_panel(fill = c("lightblue", "grey80"))}).}

\item{title}{A list with text style parameters for the title.}

\item{text}{List with text parameters (\verb{"family", "face", "colour", "size", "hjust", "vjust", "angle", "lineheight", "margin"}). See \code{\link[=element_text]{element_text()}}.}

\item{background}{A list with background styling arguments (fill, color,
size, linetype).}
}
\value{
An object of class \code{scplot} (see\code{\link[=scplot]{scplot()}}) with changed element
\code{legend}.
}
\description{
Add a legend to an scplot
}
\examples{
data(exampleAB_add, package = "scan")
scplot(exampleAB_add) |>
  set_dataline("depression") |>
  add_statline("mean") |>
  add_legend()

scplot(exampleAB_add) |>
  set_dataline(label = "Pychological Wellbeing") |>
  set_dataline("depression", color = "darkblue", label = "Depression") |>
  add_statline("mean", label = "Wellbeing mean") |>
  add_statline("mean", variable = "depression", label = "Depression mean") |>
  set_phasenames(color = NA) |>
  set_panel(fill = c("lightblue", "grey80")) |>
  add_legend(
    position = "left",
    section_labels = c("Variables", "Section"),
    title = list(color = "brown", size = 10, face = 2),
    text = list(color = "darkgreen", size = 10, face = 2),
    background = list(color = "lightgrey")
  )
}
