% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ConvertGeneIdentifiers.R
\name{ConvertGeneIdentifiers}
\alias{ConvertGeneIdentifiers}
\title{Convert Gene Identifiers in a Seurat Object}
\usage{
ConvertGeneIdentifiers(
  seurat_object,
  id_type = "refseq",
  to_id_type = "symbol"
)
}
\arguments{
\item{seurat_object}{A Seurat object. The row names of the Seurat object's data or assay slot should represent gene identifiers (e.g., RefSeq, Ensembl, or Entrez IDs).}

\item{id_type}{A string specifying the type of the input gene identifiers. Options are: "refseq", "ensembl", "entrez". Default is "refseq".}

\item{to_id_type}{A string specifying the type of output gene identifiers. Options are: "symbol", "ensembl". Default is "symbol".}
}
\value{
A Seurat object with updated gene names (row names) based on the specified conversion.
}
\description{
This function takes a Seurat object with gene identifiers as row names (e.g., RefSeq, Ensembl, Entrez)
and converts those identifiers to gene symbols (or Ensembl Gene IDs) using the biomaRt package.
The function can handle various types of gene identifiers and returns a Seurat object with updated row names.
}
\examples{
\donttest{
# Read 10X counts data from matrix.mtx, barcodes.tsv and genes.tsv
library(Seurat)
counts <- Read10X(data.dir = "../inst/extdata", gene.column = 1)

# Create Seurat object without batch correction
seurat_obj <- SeuratPreprocess(counts)
seurat_obj <- SeuratLowDim(seurat_obj)
# Convert RefSeq IDs to gene symbols
seurat_obj_converted <- ConvertGeneIdentifiers(
  seurat_obj,
  id_type = "refseq",
  to_id_type = "symbol"
)
}
}
