% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tt_pos_and_access.R
\docType{methods}
\name{head}
\alias{head}
\alias{head,VTableTree-method}
\alias{tail}
\alias{tail,VTableTree-method}
\title{Head and tail methods}
\usage{
head(x, ...)

\S4method{head}{VTableTree}(
  x,
  n = 6,
  ...,
  keep_topleft = TRUE,
  keep_titles = TRUE,
  keep_footers = keep_titles,
  reindex_refs = FALSE
)

tail(x, ...)

\S4method{tail}{VTableTree}(
  x,
  n = 6,
  ...,
  keep_topleft = TRUE,
  keep_titles = TRUE,
  keep_footers = keep_titles,
  reindex_refs = FALSE
)
}
\arguments{
\item{x}{an object}

\item{...}{arguments to be passed to or from other methods.}

\item{n}{an integer vector of length up to \code{dim(x)} (or 1,
    for non-dimensioned objects).  A \code{logical} is silently coerced to
    integer.  Values specify the indices to be
    selected in the corresponding dimension (or along the length) of the
    object. A positive value of \code{n[i]} includes the first/last
    \code{n[i]} indices in that dimension, while a negative value
    excludes the last/first \code{abs(n[i])}, including all remaining
    indices. \code{NA} or non-specified values (when \code{length(n) <
      length(dim(x))}) select all indices in that dimension. Must
    contain at least one non-missing value.}

\item{keep_topleft}{(\code{flag})\cr if \code{TRUE} (the default), top_left material for the table will be carried over to the
subset.}

\item{keep_titles}{(\code{flag})\cr if \code{TRUE} (the default), all title material for the table will be carried over to the
subset.}

\item{keep_footers}{(\code{flag})\cr if \code{TRUE}, all footer material for the table will be carried over to the subset. It
defaults to \code{keep_titles}.}

\item{reindex_refs}{(\code{flag})\cr defaults to \code{FALSE}. If \code{TRUE}, referential footnotes will be reindexed for the
subset.}
}
\description{
Head and tail methods
}
