% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.preparation_function.R
\name{data_preparation}
\alias{data_preparation}
\title{Prepare the dataset in the proper format for R2jags}
\usage{
data_preparation(data, measure)
}
\arguments{
\item{data}{A data-frame of the one-trial-per-row format with arm-level data.
See 'Format' in \code{\link{run_model}}.}

\item{measure}{Character string indicating the effect measure. For a binary
outcome, the following can be considered: \code{"OR"}, \code{"RR"} or
\code{"RD"} for the odds ratio, relative risk, and risk difference,
respectively. For a continuous outcome, the following can be considered:
\code{"MD"}, \code{"SMD"}, or \code{"ROM"} for mean difference,
standardised mean difference and ratio of means, respectively.}
}
\value{
A list of data-frames on the following elements to be passed
  to \code{\link{run_model}}:
  \item{pseudo_m}{A pseudo-data-frame with values -1 and \strong{m} for the
  corresponding trial-arms with unreported and reported missing participant
  outcome data, respectively (see 'Details').}
  \item{m}{The number of missing participant outcome data in each
  trial-arm (see 'Details').}
  \item{N}{The number of randomised participants in each trial-arm.}
  \item{t}{The intervention identifier in each trial-arm.}
  \item{I}{A pseudo-data-frame that indicates whether missing participant
  outcome data have been reported or not for each observed trial-arm
  (see 'Details').}
  \item{measure}{The effect measure for the analysed outcome.}
  \item{y0}{The observed mean value of the outcome in each trial-arm,
  when the outcome is continuous.}
  \item{se0}{The observed standard deviation of the outcome in each
  trial-arm, when the outcome is continuous.}
  \item{r}{The number of observed events of the outcome in each
  trial-arm, when the outcome is binary.}
}
\description{
\code{data_preparation} prepares the dataset in the proper format for
  R2jags and returns a list of elements that \code{\link{run_model}} inherits
  via the argument \code{data}.
}
\details{
\code{data_preparation} prepares the data for the Bayesian analysis
  (See 'Format' in \code{\link{run_model}}). \code{data_preparation}
  creates the pseudo-data-frames \code{m_new}, \code{I}, and \code{m_pseudo}
  that have the same dimensions with the element \code{N}. \code{m_new} takes
  the zero value for the observed trial-arms with unreported missing
  participant outcome data (i.e., \strong{m} equals \code{NA} for the
  corresponding trial-arms), the same value with \strong{m} for the observed
  trial-arms with reported missing participant outcome data, and \code{NA}
  for the unobserved trial-arms. \code{I} is a dummy data-frame and takes the
  value one for the observed trial-arms with reported missing participant
  outcome data, the zero value for the observed trial-arms with unreported
  missing participant outcome data (i.e., \code{m_new} equals zero for the
  corresponding trial-arms), and \code{NA} for the unobserved trial-arms.
  Thus, \code{I} indicates whether missing participant outcome data have been
  collected for the observed trial-arms. If the user has not defined the
  element \strong{m} in \code{data_preparation}, \code{m_new} and \code{I}
  take the zero value for all observed trial-arms to indicate that no missing
  participant outcome data have been collected for the analysed outcome.
  \code{I} and \code{m_new} are used from the following functions of the
  package: \code{\link{run_model}}, \code{\link{run_metareg}},
  \code{\link{prepare_model}}, \code{\link{run_nodesplit}},
  \code{\link{prepare_nodesplit}}, \code{\link{run_ume}},
  \code{\link{prepare_ume}}, and  \code{\link{run_sensitivity}}.
  Lastly, \code{m_pseudo} is a variant of \code{m_new}: it takes the value -1
  for the observed trial-arms with unreported missing participant outcome
  data (i.e., \strong{m} equals \code{NA} for the corresponding trial-arms),
  the same value with \strong{m} for the observed trial-arms with reported
  missing participant outcome data, and \code{NA} for the unobserved
  trial-arms. It is used in function \code{\link{heatmap_missing_network}} to
  calculate and illustrate the percentage of missing participant outcome data
  across the observed comparisons and interventions of the network and the
  function \code{\link{heatmap_missing_dataset}} to illustrate the trial-arms
  with unreported missing participant outcome data. All pseudo-data-frames
  aim to retain the trials without information on missing participant outcome
  data.

  Furthermore, \code{data_preparation} sorts the interventions across
  the arms of each trial in an ascending order and correspondingly the
  remaining elements in \code{data} (See 'Format' in
  \code{\link{run_model}}). \code{data_preparation} considers the first
  column in \strong{t} as being the control arm for every trial. Thus,
  this sorting ensures that interventions with a lower identifier are
  consistently treated as the control arm in each trial. This case is
  relevant in non-star-shaped networks.
}
\seealso{
\code{\link{heatmap_missing_dataset}},
  \code{\link{heatmap_missing_network}},
  \href{https://CRAN.R-project.org/package=R2jags}{R2jags},
  \code{\link{run_metareg}}, \code{\link{run_model}},
  \code{\link{run_nodesplit}}, \code{\link{run_sensitivity}},
  \code{\link{run_ume}}, \code{\link{prepare_model}},
  \code{\link{prepare_nodesplit}}, \code{\link{prepare_ume}}
}
\author{
{Loukia M. Spineli}
}
