% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipe.R
\name{\%>>\%}
\alias{\%>>\%}
\title{A pipe operator for rmake rules}
\usage{
lhs \%>>\% rhs
}
\arguments{
\item{lhs}{A dependency file name or a call to a function that creates a \code{rmake.rule}.}

\item{rhs}{A target file or a call to a function that creates a \code{rmake.rule}.}
}
\value{
A list of instances of the \code{rmake.rule} class.
}
\description{
This pipe operator simplifies the definition of multiple rmake rules that constitute a chain,
that is, if a first rule depends on the results of a second rule, which depends on the results
of a third rule and so on.
}
\details{
The format of proper usage is as follows:
\code{'inFile' \%>>\% rule() \%>>\% 'outFile'},
which is equivalent to the call \code{rule(depends='inFile', target='outFile')}. \code{rule} must be
a function that accepts the named parameters \code{depends} and \code{target} and creates the
\code{rmake.rule} object (see \code{\link[=rule]{rule()}}, \code{\link[=rRule]{rRule()}}, \code{\link[=markdownRule]{markdownRule()}}, etc.).
\code{inFile} and \code{outFile} are file names.

Multiple rules may be pipe-lined as follows:
\code{'inFile' \%>>\% rRule('script1.R') \%>>\% 'medFile' \%>>\% rRule('script2.R') \%>>\% 'outFile'},
which is equivalent to a job of two rules created with:
\code{rRule(script='script1.R', depends='inFile', target='medFile')} and
\code{rRule(script='script2.R', depends='medFile', target='outFile')}.
}
\examples{

job1 <- 'data.csv' \%>>\%
  rRule('preprocess.R') \%>>\%
  'data.rds' \%>>\%
  markdownRule('report.rnw') \%>>\%
  'report.pdf'

# is equivalent to

job2 <- list(rRule(target='data.rds', script='preprocess.R', depends='data.csv'),
             markdownRule(target='report.pdf', script='report.rnw', depends='data.rds'))
}
\seealso{
\code{\link[=rule]{rule()}}, \code{\link[=makefile]{makefile()}}
}
\author{
Michal Burda (\verb{\%>>\%} operator is derived from the code of the \code{magrittr} package by
Stefan Milton Bache and Hadley Wickham)
}
