% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table1_design.R
\name{table1_design}
\alias{table1_design}
\title{Design A Descriptive Table}
\usage{
table1_design(
  data,
  ...,
  by = NULL,
  total = TRUE,
  empty_levels = FALSE,
  na_always = FALSE,
  na_label = "Unknown",
  continuous_type = "median (iqr)",
  binary_type = "outcomes (risk)"
)
}
\arguments{
\item{data}{Data set}

\item{...}{Optional: Variables to include or exclude (using \code{-variable})}

\item{by}{Optional: Stratification variable. Typically the exposure.}

\item{total}{Optional: Whether to add the total count at the beginning.
Defaults to \code{TRUE}.}

\item{empty_levels}{Optional: Whether to include empty levels of factor
variables. Defaults to \code{FALSE}.}

\item{na_always}{Optional: Whether to add the count of missing values for
each variable, even if there are none. Defaults to \code{FALSE}, i.e.,
the count of missing values will only be shown if there are any.}

\item{na_label}{Label for count of missing values. Defaults to
\code{"Unknown"}.}

\item{continuous_type}{Estimator (\code{type} in
\code{\link[rifttable]{rifttable}} \code{design}) for continuous variables.
Defaults to \code{"median (iqr)"}.}

\item{binary_type}{Estimator (\code{type} in
\code{\link[rifttable]{rifttable}} \code{design}) for binary variables and
strata of categorical variables. Defaults to \code{"outcomes (risk)"}
(count and column proportion).}
}
\value{
\code{design} tibble that can be passed on to
\code{\link[rifttable]{rifttable}}. Contains an attribute \code{rt_data}
so that the dataset does not have to be provided to
\code{\link[rifttable]{rifttable}} another time.
}
\description{
This function generates a \code{design} table from which
\code{\link[rifttable]{rifttable}} can generate a descriptive table.
}
\examples{
# Data preparation
cars <- tibble::as_tibble(mtcars) |>
  dplyr::mutate(
    gear = factor(
      gear,
      levels = 3:5,
      labels = c("Three", "Four", "Five")
    ),
    # Categorical version of "hp", shows each category
    hp_categorical = dplyr::if_else(
      hp >= 200,
      true = "200+ hp",
      false = "<200 hp"
    ),
    # Binary version of "hp", shows the TRUEs
    hp_binary = hp >= 200
  )
# Label some variables. Better alternative: labelled::set_variable_labels()
attr(cars$hp, "label") <- "Horsepower"
attr(cars$hp_categorical, "label") <- "Horsepower"
attr(cars$hp_binary, "label") <- "200+ hp"
attr(cars$am, "label") <- "Automatic transmission"
attr(cars$gear, "label") <- "Gears"

# Generate table "design"
design <- cars |>
  table1_design(
    hp, hp_categorical, hp_binary, mpg, am,
    by = gear
  )

# Use "design" to create a descriptive table.
design |>
  rifttable(diff_digits = 0)

# Obtain a formatted table
design |>
  rifttable(diff_digits = 0) |>
  rt_gt()
}
