% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rt_gt.R
\name{rt_gt}
\alias{rt_gt}
\title{Turn tibble into gt Table with Custom Formatting}
\usage{
rt_gt(df, md = 1, indent = 10, remove_border = TRUE)
}
\arguments{
\item{df}{Data frame/tibble}

\item{md}{Optional. If not \code{NULL}, then the given
columns will be printed with markdown formatting, e.g., \code{md = c(1, 3)}
for columns 1 and 3. Defaults to \code{1}, i.e., the first column.}

\item{indent}{Optional. Detects cells in the first column of table, e.g.,
from \code{\link[rifttable]{rifttable}} where the first column contains the
labels, that start with at least two spaces. This text is then indented via
\code{\link[gt]{tab_style}}. Defaults \code{10} for 10 pixels. Set to
\code{NULL} to turn off.}

\item{remove_border}{Optional. For rows that are indented in the first
column or have an empty first column, remove the upper horizontal border
line? Defaults to \code{TRUE}.}
}
\value{
Formatted gt table
}
\description{
Formatting includes:
\itemize{
\item Text align to top/left
\item Smaller row padding
\item No top border
\item Bold column labels
}

If this function is called within a document that is being knit to plain
markdown, such as \code{format: gfm} in a Quarto document or
\code{format: github_document} in an RMarkdown document, then a plain
markdown-formatted table (e.g., without footnotes) is returned via
\code{\link[knitr]{kable}}.
}
\examples{
data(mtcars)
mtcars |>
  dplyr::slice(1:5) |>
  rt_gt()

}
