% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rl_scopes.R
\name{rl_scopes}
\alias{rl_scopes}
\title{IUCN Red List assessment scopes}
\usage{
rl_scopes(
  code = NULL,
  year_published = NULL,
  latest = NULL,
  possibly_extinct = NULL,
  possibly_extinct_in_the_wild = NULL,
  scope_code = scope_code \%||\% NA,
  page = 1
)
}
\arguments{
\item{code}{Character or Numeric. One or more scope codes (e.g., "1", "2").
Use \code{\link[=rl_scopes]{rl_scopes()}} to list available scope categories.}

\item{year_published}{Optional. Single or numeric vector of years to filter assessments by publication year.}

\item{latest}{Optional. Logical. If \code{TRUE}, return only the latest assessment per species.}

\item{possibly_extinct}{Optional. Logical. Filter for species flagged as possibly extinct.}

\item{possibly_extinct_in_the_wild}{Optional. Logical. Filter for species possibly extinct in the wild.}

\item{scope_code}{Optional. Integer One or more scope codes to filter assessments.}

\item{page}{Optional. Integer vector. Specify one or more page numbers to fetch.
If \code{NULL} or \code{NA}, all pages will be fetched automatically.}
}
\value{
A tibble (class \code{tbl_df}, \code{tbl}, \code{data.frame}) where each column represents a unique API response JSON key.
If \code{code = NULL}, the tibble contains available assessment scopes with columns such as code and description.
If \code{code} is provided, the tibble contains assessment data for the specified scope(s), including, description, year, latest, taxon details,
and other relevant metadata.
}
\description{
Retrieve species assessments based on their geographic assessment scopes.
If \code{code = NULL}, it returns a list of available assessment scopes.
If \code{code} is provided, it retrieves assessments for the specified scope(s).
}
\examples{
\dontrun{
# List all assessment scopes
rl_scopes()

# Get globally assessed species (code 1)
rl_scopes(code = "1")

# Get Pan-Africa species assessed species published since 2020
rl_scopes(
  code = "2",
  year_published = 2020:2023
)
}
}
