% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fn_get.R
\name{get_from_lup_obj}
\alias{get_from_lup_obj}
\title{Get a value from a lookup table}
\usage{
get_from_lup_obj(
  data_lookup_tb,
  match_value_xx,
  match_var_nm_1L_chr,
  target_var_nm_1L_chr,
  evaluate_1L_lgl = FALSE
)
}
\arguments{
\item{data_lookup_tb}{Data lookup (a tibble)}

\item{match_value_xx}{Match value (an output object of multiple potential types)}

\item{match_var_nm_1L_chr}{Match variable name (a character vector of length one)}

\item{target_var_nm_1L_chr}{Target variable name (a character vector of length one)}

\item{evaluate_1L_lgl}{Evaluate (a logical vector of length one), Default: FALSE}
}
\value{
Cell value (an output object of multiple potential types)
}
\description{
get_from_lup_obj() retrieves from a lookup table (a data.frame) the values in a target column for cases where values in a second column match a specified value.
}
\examples{
lookup_tb <- tibble::tibble(Name = c("Sajid","Siobhan"),
                            Treat = c("Cake", "Chocolate"))
get_from_lup_obj(lookup_tb, match_value_xx = "Siobhan",
                 match_var_nm_1L_chr = "Name", target_var_nm_1L_chr = "Treat")
get_from_lup_obj(lookup_tb, match_value_xx = "Cake",
                 match_var_nm_1L_chr = "Treat", target_var_nm_1L_chr = "Name")

}
