% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/valley.R
\name{delineate_valley}
\alias{delineate_valley}
\title{Extract the river valley from the DEM}
\usage{
delineate_valley(dem, river)
}
\arguments{
\item{dem}{\code{SpatRaster} object with the digital elevation model of the region}

\item{river}{An object of class \code{\link[sf:sf]{sf::sf}} or \code{\link[sf:sfc]{sf::sfc}}
representing the river}
}
\value{
River valley as a simple feature geometry of class \code{sfc_MULTIPOLYGON}
}
\description{
The slope of the digital elevation model (DEM) is used as friction (cost)
surface to compute the cost distance from any grid cell of the raster to
the river. A characteristic value (default: the mean) of the cost distance
distribution in a region surrounding the river (default: a buffer region of
2 km) is then calculated, and used to threshold the cost-distance surface.
The resulting area is then "polygonized" to obtain the valley boundary as a
simple feature geometry.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
bucharest_osm <- get_osm_example_data()
bucharest_dem <- get_dem_example_data()
delineate_valley(bucharest_dem, bucharest_osm$river_centerline)
\dontshow{\}) # examplesIf}
}
