% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{read_env}
\alias{read_env}
\title{Read environment variables from a file}
\usage{
read_env(path)
}
\arguments{
\item{path}{A string specifying the path to the \code{.env} file. If not provided, defaults to \code{.env} in the current working directory.}
}
\value{
A named list of environment variables. Each element is a key-value pair extracted from the file. If no variables are found, \code{NULL} is returned.
}
\description{
Reads a \code{.env} file containing environment variables in the format \code{KEY=VALUE}, and returns them as a named list.
Lines starting with \code{#} are considered comments and ignored.
}
\examples{
\dontrun{
# Assuming an `.env` file with the following content:
# DB_HOST=localhost
# DB_USER=root
# DB_PASS="secret"

env_vars <- read_env(".env")
print(env_vars)
# Should output something like:
# $DB_HOST
# [1] "localhost"

# If no path is given, it defaults to `.env` in the current directory.
env_vars <- read_env()
}
}
