% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_man.R
\name{write_man}
\alias{write_man}
\title{Write a manual page for package dataset documentation}
\usage{
write_man(the_dataset)
}
\arguments{
\item{the_dataset}{Dataset object (unquoted) or dataset as character (quoted)}
}
\value{
A \code{.Rd} file in the \code{man} package directory corresponding to the
name of the supplied dataset.
}
\description{
This function produces a \code{roxygen2} R manual (man) page for a dataset that will
be included in an R package. To be documented, the dataset needs to be in the global
environment. The new documentation template will be named to match the datasets and
will be saved in the R folder (i.e., using an \code{analysis} dataset will produce the
\code{R/analysis.Rd} file). The page will indicate if the dataset is a data frame
or tibble along with the number of rows and columns. For each variable documentation
will indicate the variables a type, factor level information (if appropriate), and a
generic description section. If the variable is labelled (using the labelled package
or packages which use labelled, like \code{tidyREDCap}) the variable label will be
used as the default description.
}
\note{
You will need to import the \code{roxygen2} package and add \code{Roxygen: list(markdown = TRUE)}
to your DESCRIPTION file. If you made a project using rUM this happens automatically.
}
\examples{
if (interactive()) {
  # Dataset object from Global Environment (unquoted)
  write_man(mtcars)
  
  # Dataset object from Global Environment as character string (quoted)
  write_man("mtcars")
}
}
