% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_cohorts.R
\name{get_cohorts}
\alias{get_cohorts}
\title{Get PGS Catalog Cohorts}
\usage{
get_cohorts(
  cohort_symbol = NULL,
  verbose = FALSE,
  warnings = TRUE,
  progress_bar = TRUE
)
}
\arguments{
\item{cohort_symbol}{A cohort symbol or \code{NULL} if all cohorts are
intended.}

\item{verbose}{A \code{logical} indicating whether the function should be
verbose about the different queries or not.}

\item{warnings}{A \code{logical} indicating whether to print warnings, if any.}

\item{progress_bar}{Whether to show a progress bar indicating download
progress from the REST API server.}
}
\value{
A \linkS4class{cohorts} object.
}
\description{
Retrieves cohorts via the PGS Catalog REST API. Please note that all
\code{cohort_symbol} is vectorised, thus allowing for batch mode search.
}
\examples{
# Get information about specific cohorts by their symbols (acronyms)
get_cohorts(cohort_symbol = c('23andMe', 'IPOBCS'))

# Get info on all cohorts (may take a few minutes to download)
\dontrun{
get_cohorts()
}

}
