% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_ancestry_categories.R
\name{get_ancestry_symbol_mappings}
\alias{get_ancestry_symbol_mappings}
\title{Get PGS Catalog Ancestry Symbol Mappings}
\usage{
get_ancestry_symbol_mappings(
  verbose = FALSE,
  warnings = TRUE,
  progress_bar = TRUE
)
}
\arguments{
\item{verbose}{A \code{logical} indicating whether the function should be
verbose about the different queries or not.}

\item{warnings}{A \code{logical} indicating whether to print warnings, if any.}

\item{progress_bar}{Whether to show a progress bar indicating download
progress from the REST API server.}
}
\value{
Return a tibble of mappings between the ancestry symbols and their
name, e.g. EUR and European, respectively.
}
\description{
Retrieves the mappings between the ancestry class symbols and ancestry class
via the PGS Catalog REST API. Note: this function is not exported and should
only be used for debugging reasons. Use in alternative
\code{\link{get_ancestry_categories}}.
}
\keyword{internal}
