% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting-helpers.R
\name{layerNames}
\alias{layerNames}
\alias{layerNames,ANY-method}
\title{Extract the layer names of Spatial Objects}
\usage{
layerNames(object)

\S4method{layerNames}{ANY}(object)
}
\arguments{
\item{object}{A \verb{Raster*}, \verb{SpatialPoints*}, \verb{SpatialLines*},
or \verb{SpatialPolygons*} object; or list of these.}
}
\description{
There are already methods for \verb{Raster*} objects. This adds methods for
\verb{SpatialPoints*}, \verb{SpatialLines*}, and \verb{SpatialPolygons*},
returning an empty character vector of length 1.
This function was created to give consistent, meaningful results for all
classes of objects plotted by \code{Plot}.
}
\examples{
library(terra)

## RasterLayer objects
files <- system.file("maps", package = "quickPlot")
files <- dir(files, full.names = TRUE, pattern = "tif")
maps <- lapply(files, function(x) terra::rast(x))
names(maps) <- sapply(basename(files), function(x) {
  strsplit(x, split = "\\\\.")[[1]][1]
})
layerNames(maps)

## SpatVector objects
caribou <- terra::vect(
  cbind(
    x = stats::runif(1e2, -50, 50),
    y = stats::runif(1e2, -50, 50)
  )
)
layerNames(caribou)

}
\author{
Eliot McIntire
}
