% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-projects.R
\name{get_running_project_root}
\alias{get_running_project_root}
\title{Get the root of the currently running Quarto project}
\usage{
get_running_project_root()
}
\value{
Character Quarto project root path from set environment variables.
}
\description{
This function is to be used inside cells and will return the project root
when doing \code{\link[=quarto_render]{quarto_render()}} by detecting Quarto project environment variables.
}
\details{
Quarto sets \code{QUARTO_PROJECT_ROOT} and \code{QUARTO_PROJECT_DIR} environment
variables when executing commands within a Quarto project context (e.g.,
\verb{quarto render}, \verb{quarto preview}). This function detects their presence.

Note that this function will return \code{NULL} when running code interactively
in an IDE (even within a Quarto project directory), as these specific
environment variables are only set during Quarto command execution.
}
\section{Use in Quarto document cells}{


This function is particularly useful in Quarto document cells where you want to
get the project root path dynamically during rendering. Cell example:

\if{html}{\out{<div class="sourceCode markdown">}}\preformatted{```\{r\}`r ''`
 # Get the project root path
 project_root <- get_running_project_root()
```
}\if{html}{\out{</div>}}
}

\examples{
\dontrun{
get_running_project_root()
}
}
\seealso{
\itemize{
\item \code{\link[=find_project_root]{find_project_root()}} for finding the Quarto project root directory
\item \code{\link[=project_path]{project_path()}} for constructing paths relative to the project root
}
}
