% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setScreenSize.R
\name{setScreenSize}
\alias{setScreenSize}
\title{Set default maximum screen size}
\usage{
setScreenSize(size = c("normal", "small", "large"), height, width)
}
\arguments{
\item{size}{Character vector representing screen size (normal,
small, large). Ignored if height and width are provided.}

\item{height}{(Optional) Height in pixels}

\item{width}{(Optional) Width in pixels}
}
\value{
None.
}
\description{
Set the default screen size as a global option.
}
\details{
Used to set a global option, `qtlchartsScreenSize`, that
contains the maximum height and maximum width for a chart in the
browser.

`"small"`, `"normal"`, and `"large"` correspond to 600x900, 700x1000, and
1200x1600, for height x width, respectively.
}
\examples{
setScreenSize("large")

}
\keyword{utilities}
