% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endpoint_info.R
\name{endpoint_info}
\alias{endpoint_info}
\title{Get Information About Available Endpoints}
\usage{
endpoint_info(endpoint = NULL, format = c("list", "json"))
}
\arguments{
\item{endpoint}{Character string specifying which endpoint to get information about.
If NULL (default), returns a list of all available endpoints.}

\item{format}{Character string specifying the output format. Either "list" (default)
or "json" for JSON-formatted output.}
}
\value{
If \code{endpoint} is NULL, returns a character vector of available endpoint names.
  If \code{endpoint} is specified, returns a list (or JSON string) with detailed information
  about that endpoint including description, columns, parameters, rate limits, and notes.
}
\description{
This function provides detailed information about the available endpoints
in the package, including column descriptions, parameters, rate limits, and usage notes.
}
\examples{
\donttest{
if (interactive()) {
  # List all available endpoints
  endpoint_info()
  
  # Get information about a specific endpoint
  endpoint_info("pubmed_abstracts")
  
  # Get information in JSON format
  endpoint_info("icites", format = "json")
}
}

}
