% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.projoint_tau.R
\name{plot.projoint_tau}
\alias{plot.projoint_tau}
\title{Plot method for \code{projoint_tau}}
\usage{
\method{plot}{projoint_tau}(x, ...)
}
\arguments{
\item{x}{A \code{projoint_tau} object.}

\item{...}{Optional arguments (currently unused).}
}
\value{
A \code{ggplot2} object representing the IRR (\eqn{\tau}) visualization.
  The plot is drawn for its side effect and also returned (invisibly).
}
\description{
Visualizes the estimated intra-respondent reliability (\eqn{\tau}) produced
by the extrapolation method and stored in a \code{projoint_tau} object.
}
\examples{
\donttest{
# Estimate tau, then plot:
# dat <- reshape_projoint(exampleData1, .outcomes = c("choice1","choice2"))
# tau_fit <- projoint_tau(dat)  # or predict_tau(dat)
# p <- plot(tau_fit)            # also returns the ggplot object (invisibly)
}
}
