% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TargetMethod-class.R
\name{TargetMethod-class}
\alias{TargetMethod-class}
\alias{TargetMethod}
\title{Target setting method class}
\description{
This class is used to represent methods for setting targets.
\strong{Only experts should use the fields and methods for this class directly.}
}
\seealso{
Other classes: 
\code{\link{ConservationModifier-class}},
\code{\link{ConservationProblem-class}},
\code{\link{Constraint-class}},
\code{\link{Decision-class}},
\code{\link{Objective-class}},
\code{\link{OptimizationProblem-class}},
\code{\link{Penalty-class}},
\code{\link{Portfolio-class}},
\code{\link{Solver-class}},
\code{\link{Target-class}},
\code{\link{Weight-class}}
}
\concept{classes}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{name}}{\code{character} value with name of method.}

\item{\code{type}}{\code{character} value denoting the target type.}

\item{\code{fun}}{\code{function} for calculating targets.}

\item{\code{args}}{\code{list} containing arguments.}

\item{\code{frame}}{defused `call for generating error messages.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-TargetMethod-new}{\code{TargetMethod$new()}}
\item \href{#method-TargetMethod-print}{\code{TargetMethod$print()}}
\item \href{#method-TargetMethod-calculate_targets}{\code{TargetMethod$calculate_targets()}}
\item \href{#method-TargetMethod-calculate_targets_km2}{\code{TargetMethod$calculate_targets_km2()}}
\item \href{#method-TargetMethod-calculate_relative_targets}{\code{TargetMethod$calculate_relative_targets()}}
\item \href{#method-TargetMethod-calculate_absolute_targets}{\code{TargetMethod$calculate_absolute_targets()}}
\item \href{#method-TargetMethod-clone}{\code{TargetMethod$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TargetMethod-new"></a>}}
\if{latex}{\out{\hypertarget{method-TargetMethod-new}{}}}
\subsection{Method \code{new()}}{
Initialize new object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TargetMethod$new(name, type, fun, args, frame)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{\code{character} value with name of method.}

\item{\code{type}}{\code{character} value denoting the target type.
Available options include \code{"relative"} and \code{"absolute"}.}

\item{\code{fun}}{\code{function} for calculating targets.}

\item{\code{args}}{\code{list} containing arguments.}

\item{\code{frame}}{defused `call for generating error messages.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{Method} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TargetMethod-print"></a>}}
\if{latex}{\out{\hypertarget{method-TargetMethod-print}{}}}
\subsection{Method \code{print()}}{
Print the object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TargetMethod$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{not used.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Invisible \code{TRUE}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TargetMethod-calculate_targets"></a>}}
\if{latex}{\out{\hypertarget{method-TargetMethod-calculate_targets}{}}}
\subsection{Method \code{calculate_targets()}}{
Calculate targets expressed in the type of units defined for the method
(per \verb{$type}).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TargetMethod$calculate_targets(x, features, call = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{\code{\link[=problem]{problem()}} object.}

\item{\code{features}}{\code{integer} feature indices.}

\item{\code{call}}{\code{NULL} or calling environment.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{numeric} vector with target values.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TargetMethod-calculate_targets_km2"></a>}}
\if{latex}{\out{\hypertarget{method-TargetMethod-calculate_targets_km2}{}}}
\subsection{Method \code{calculate_targets_km2()}}{
Calculate targets as \ifelse{html}{\out{km<sup>2</sup>}}{\eqn{km^2}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TargetMethod$calculate_targets_km2(x, features, call = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{\code{\link[=problem]{problem()}} object.}

\item{\code{features}}{\code{integer} feature indices.}

\item{\code{call}}{\code{NULL} or calling environment.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{numeric} vector with target values expressed in
\ifelse{html}{\out{km<sup>2</sup>}}{\eqn{km^2}}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TargetMethod-calculate_relative_targets"></a>}}
\if{latex}{\out{\hypertarget{method-TargetMethod-calculate_relative_targets}{}}}
\subsection{Method \code{calculate_relative_targets()}}{
Calculate targets as \ifelse{html}{\out{km<sup>2</sup>}}{\eqn{km^2}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TargetMethod$calculate_relative_targets(x, features, call = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{\code{\link[=problem]{problem()}} object.}

\item{\code{features}}{\code{integer} feature indices.}

\item{\code{call}}{\code{NULL} or calling environment.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{numeric} vector with target values expressed as relative
units.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TargetMethod-calculate_absolute_targets"></a>}}
\if{latex}{\out{\hypertarget{method-TargetMethod-calculate_absolute_targets}{}}}
\subsection{Method \code{calculate_absolute_targets()}}{
Calculate targets expressed as absolute units.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TargetMethod$calculate_absolute_targets(x, features, call = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{\code{\link[=problem]{problem()}} object.}

\item{\code{features}}{\code{integer} feature indices.}

\item{\code{call}}{\code{NULL} or calling environment.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{numeric} vector with target values expressed as
absolute units.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TargetMethod-clone"></a>}}
\if{latex}{\out{\hypertarget{method-TargetMethod-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TargetMethod$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
