% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WD_General.r
\name{WD_General}
\alias{WD_General}
\title{Weighted Deming Regression}
\usage{
WD_General(X, Y, g, h, epsilon=1e-8)
}
\arguments{
\item{X}{the vector of predicate readings.}

\item{Y}{the vector of test readings.}

\item{g}{the vector of variances of the \code{X}.}

\item{h}{the vector of variances of the \code{Y}.}

\item{epsilon}{\emph{optional}  (default of 1e-8) - convergence tolerance limit.}
}
\value{
A list containing the following components:

\item{alpha }{the fitted intercept}
\item{beta }{the fitted slope}
\item{cor }{the Pearson correlation between \code{X} and \code{Y}}
\item{fity }{the vector of predicted Y}
\item{mu }{the vector of estimated latent true values}
\item{resi }{the vector of residuals}
\item{L }{the -2 log likelihood L}
\item{innr }{the number of inner refinement loops executed}
}
\description{
This code fits the weighted Deming regression on predicate readings (X)
and test readings (Y).
}
\details{
This function is used when the variances of X and Y are already known,
as can be the case from an adequate number of replicate X and Y readings
of each sample. For input vectors \code{g} and \code{h} containing the variances of
predicate readings \code{X} and test readings \code{Y}, respectively, iteratively fits
weighted Deming regression.
}
\examples{
# library
library(ppwdeming)

# parameter specifications
alpha <- 1
beta  <- 1.1
true  <- 8*10^((0:99)/99)
truey <- alpha+beta*true
# Loosely motivated by Vitamin D data set
g     <- 4e-16+0.07*true^1.27
h     <- 6e-2+7e-5*truey^2.2

# simulate single sample - set seed for reproducibility
set.seed(1039)
# specifications for predicate method
X     <- true +sqrt(g)*rnorm(100)
# specifications for test method
Y     <- truey+sqrt(h)*rnorm(100)

# fit with to estimate linear parameters
wd_fit <- WD_General(X,Y,g,h)
cat("\nWith given g and h, the estimated intercept is",
    signif(wd_fit$alpha,4), "and the estimated slope is",
    signif(wd_fit$beta,4), "\n")

}
\references{
Ripley BD and Thompson M (1987). Regression techniques for the detection
of analytical bias.  \emph{Analyst}, \strong{112}, 377-383.
}
\author{
Douglas M. Hawkins, Jessica J. Kraker \href{mailto:krakerjj@uwec.edu}{krakerjj@uwec.edu}
}
