% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gam_cal.R
\name{gam_cal}
\alias{gam_cal}
\title{fits a calibration curve via gam}
\usage{
gam_cal(
  y,
  p,
  x,
  xp,
  time = NULL,
  save_data = TRUE,
  save_mod = TRUE,
  pw = FALSE,
  ...
)
}
\arguments{
\item{y}{binary or a time-to-event (\code{Surv}) outcome. For the former \code{family = binomial(link="logit")} and for the latter \code{family = mgcv::cox.ph()}.}

\item{p}{predicted probabilities}

\item{x}{predictor (could be transformation of \code{p})}

\item{xp}{values for plotting (same scale as \code{x})}

\item{time}{time to calculate survival probabilities at (only relevant if \code{y} is a \code{Surv} object)}

\item{save_data}{whether to save the data elements in the returned object}

\item{save_mod}{whether to save the model in the returned object}

\item{pw}{save pointwise standard errors for plotting}

\item{...}{additional arguments for \code{mgcv::gam} and \code{mgcv::s}}
}
\value{
list of class \code{gam_cal}
}
\description{
fits a calibration curve via gam
}
\examples{
library(pmcalibration)
# simulate some data
n <- 500
dat <- sim_dat(N = n, a1 = .5, a3 = .2)
head(dat)
# predictions
p <- with(dat, invlogit(.5 + x1 + x2 + x1*x2*.1))

gam_cal(y = dat$y, p = p, x = p, xp = NULL, k = 20, method="REML")
}
\keyword{internal}
