% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phy.sim.R
\name{sim.phy}
\alias{sim.phy}
\alias{sim.bd.phy}
\alias{sim.bd.tr.phy}
\alias{edge2phylo}
\title{Simulate phylogenies}
\usage{
sim.bd.phy(speciate = 0.1, extinction = 0.025, time.steps = 20)

sim.bd.tr.phy(
  speciate = 0.1,
  extinction = 0.025,
  time.steps = 20,
  tr.range = c(0, 1),
  sp.tr = 2,
  ext.tr = 1,
  tr.walk = 0.2,
  tr.wrap = TRUE
)

edge2phylo(edge, s, e = numeric(0), el = NA, t = NULL)
}
\arguments{
\item{speciate}{probability each species will speciate in each
time-step (0-1)}

\item{extinction}{probability each species will go extinct in each
time-step (0-1)}

\item{time.steps}{number of time-steps for simulation}

\item{tr.range}{vector of length two specifying boundaries for
trait values (see notes); initial two species will be at the 25th
and 75th percentiles of this space. See also \code{tr.wrap}}

\item{sp.tr}{speciation rate's interaction with the minimum
distance between a species and the species most similar to it (see
details)}

\item{ext.tr}{extinction rate's interaction with the minimum
distance between a species and the species most similar to it (see
details)}

\item{tr.walk}{at each time-step a species not undergoing
speciation or extinction has its trait value drawn from a
distribution centered at its current value and with a standard
deviation set by this value. I.e., this is the rate of the Brownian
motion trait evolution.}

\item{tr.wrap}{whether to force species' trait values to stay
within the boundary defined by \code{tr.range}; default TRUE.}

\item{edge}{a two-column matrix where the first column is the start
node, the second the destination, as in
\code{\link[ape:phylo]{phylo}$edge}}

\item{s}{which of the rows in the edge matrix represent
extant species}

\item{e}{which of the tips in the edge matrix are extinct
(DEFAULT: empty vector, i.e., none)}

\item{el}{a vector to be used to give edge.length to the
phylogeny (default NA, i.e., none)}

\item{t}{if given (default NA), a vector to be used for traits
(\code{$traits} slot) in the phylogeny}
}
\value{
\code{\link[ape:phylo]{phylo}} object with random
tip.labels, and trait values if using \code{sim.br.tr.tree}.
}
\description{
Simulate phylogenies under pure birth/death or as a function of
trait evolution
}
\details{
\code{sim.bd.tree} simulates a pure birth/death speciation
model. There are two important things to note: (1) speciation is
randomised before extinction, and only one thing can happen to a
lineage per timestep. (2) This code works well for my purposes, but
absurd parameter values can cause the function to crash.

\code{sim.bd.tr.tree} is an extension of \code{sim.bd.tree}, and
all its caveats apply to it. It additionally simulated the
evolution of a trait under Brownain motion
(\code{tr.walk}). Species' speciation/extinction rates change
depending on whether they have a trait value similar to other
species (\code{sp.tr}, \code{ext.tr}). When a speciation event
happens, the two daughters split evenly about the ancestor's trait
value, taking values half-way to whatever the nearest species'
value is. To be precise: \eqn{p(speciate)_i = speciate_i + sp.tr
\times min(trait distance)}{p(speciate) = speciate +
sp.tr*min.tr.dist}, \eqn{p(extinct)_i = exinction_i + ext.tr
\times min(trait distance)}{p(extinct) = extinction +
ext.tr*min.tr.dist}, where \eqn{i}{i} denotes each species.

\code{edge2phylo} is an internal function for the
\code{\link{sim.phy}} and \code{\link{sim.meta}} function families,
which may be of use to you. Check those functions' code for
examples of use.

These functions are closely related to \code{\link{sim.meta}}; the
latter are extensions that simulate meta-community structure at the
same time.
}
\examples{
tree <- sim.bd.phy(0.1, 0, 10)
plot(tree)
}
\seealso{
sim.meta scape
}
\author{
Will Pearse
}
