% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vpclattice_operations.R
\name{vpclattice_create_resource_configuration}
\alias{vpclattice_create_resource_configuration}
\title{Creates a resource configuration}
\usage{
vpclattice_create_resource_configuration(
  allowAssociationToShareableServiceNetwork = NULL,
  clientToken = NULL,
  name,
  portRanges = NULL,
  protocol = NULL,
  resourceConfigurationDefinition = NULL,
  resourceConfigurationGroupIdentifier = NULL,
  resourceGatewayIdentifier = NULL,
  tags = NULL,
  type
)
}
\arguments{
\item{allowAssociationToShareableServiceNetwork}{(SINGLE, GROUP, ARN) Specifies whether the resource configuration can be
associated with a sharable service network. The default is false.}

\item{clientToken}{A unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. If you retry a request that completed
successfully using the same client token and parameters, the retry
succeeds without performing any actions. If the parameters aren't
identical, the retry fails.}

\item{name}{[required] The name of the resource configuration. The name must be unique within
the account. The valid characters are a-z, 0-9, and hyphens (-). You
can't use a hyphen as the first or last character, or immediately after
another hyphen.}

\item{portRanges}{(SINGLE, GROUP, CHILD) The TCP port ranges that a consumer can use to
access a resource configuration (for example: 1-65535). You can separate
port ranges using commas (for example: 1,2,22-30).}

\item{protocol}{(SINGLE, GROUP) The protocol accepted by the resource configuration.}

\item{resourceConfigurationDefinition}{(SINGLE, CHILD, ARN) The resource configuration.}

\item{resourceConfigurationGroupIdentifier}{(CHILD) The ID or ARN of the parent resource configuration (type is
\code{GROUP}). This is used to associate a child resource configuration with
a group resource configuration.}

\item{resourceGatewayIdentifier}{(SINGLE, GROUP, ARN) The ID or ARN of the resource gateway used to
connect to the resource configuration. For a child resource
configuration, this value is inherited from the parent resource
configuration.}

\item{tags}{The tags for the resource configuration.}

\item{type}{[required] The type of resource configuration.
\itemize{
\item \code{SINGLE} - A single resource.
\item \code{GROUP} - A group of resources. You must create a group resource
configuration before you create a child resource configuration.
\item \code{CHILD} - A single resource that is part of a group resource
configuration.
\item \code{ARN} - An Amazon Web Services resource.
}}
}
\description{
Creates a resource configuration. A resource configuration defines a specific resource. You can associate a resource configuration with a service network or a VPC endpoint.

See \url{https://www.paws-r-sdk.com/docs/vpclattice_create_resource_configuration/} for full documentation.
}
\keyword{internal}
