% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudfront_operations.R
\name{cloudfront_update_distribution_with_staging_config}
\alias{cloudfront_update_distribution_with_staging_config}
\title{Copies the staging distribution's configuration to its corresponding
primary distribution}
\usage{
cloudfront_update_distribution_with_staging_config(
  Id,
  StagingDistributionId = NULL,
  IfMatch = NULL
)
}
\arguments{
\item{Id}{[required] The identifier of the primary distribution to which you are copying a
staging distribution's configuration.}

\item{StagingDistributionId}{The identifier of the staging distribution whose configuration you are
copying to the primary distribution.}

\item{IfMatch}{The current versions (\code{ETag} values) of both primary and staging
distributions. Provide these in the following format:

\verb{<primary ETag>, <staging ETag>}}
}
\description{
Copies the staging distribution's configuration to its corresponding primary distribution. The primary distribution retains its \code{Aliases} (also known as alternate domain names or CNAMEs) and \code{ContinuousDeploymentPolicyId} value, but otherwise its configuration is overwritten to match the staging distribution.

See \url{https://www.paws-r-sdk.com/docs/cloudfront_update_distribution_with_staging_config/} for full documentation.
}
\keyword{internal}
