% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_update_mlflow_tracking_server}
\alias{sagemaker_update_mlflow_tracking_server}
\title{Updates properties of an existing MLflow Tracking Server}
\usage{
sagemaker_update_mlflow_tracking_server(
  TrackingServerName,
  ArtifactStoreUri = NULL,
  TrackingServerSize = NULL,
  AutomaticModelRegistration = NULL,
  WeeklyMaintenanceWindowStart = NULL
)
}
\arguments{
\item{TrackingServerName}{[required] The name of the MLflow Tracking Server to update.}

\item{ArtifactStoreUri}{The new S3 URI for the general purpose bucket to use as the artifact
store for the MLflow Tracking Server.}

\item{TrackingServerSize}{The new size for the MLflow Tracking Server.}

\item{AutomaticModelRegistration}{Whether to enable or disable automatic registration of new MLflow models
to the SageMaker Model Registry. To enable automatic model registration,
set this value to \code{True}. To disable automatic model registration, set
this value to \code{False}. If not specified, \code{AutomaticModelRegistration}
defaults to \code{False}}

\item{WeeklyMaintenanceWindowStart}{The new weekly maintenance window start day and time to update. The
maintenance window day and time should be in Coordinated Universal Time
(UTC) 24-hour standard time. For example: TUE:03:30.}
}
\description{
Updates properties of an existing MLflow Tracking Server.

See \url{https://www.paws-r-sdk.com/docs/sagemaker_update_mlflow_tracking_server/} for full documentation.
}
\keyword{internal}
