% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_create_compute_quota}
\alias{sagemaker_create_compute_quota}
\title{Create compute allocation definition}
\usage{
sagemaker_create_compute_quota(
  Name,
  Description = NULL,
  ClusterArn,
  ComputeQuotaConfig,
  ComputeQuotaTarget,
  ActivationState = NULL,
  Tags = NULL
)
}
\arguments{
\item{Name}{[required] Name to the compute allocation definition.}

\item{Description}{Description of the compute allocation definition.}

\item{ClusterArn}{[required] ARN of the cluster.}

\item{ComputeQuotaConfig}{[required] Configuration of the compute allocation definition. This includes the
resource sharing option, and the setting to preempt low priority tasks.}

\item{ComputeQuotaTarget}{[required] The target entity to allocate compute resources to.}

\item{ActivationState}{The state of the compute allocation being described. Use to enable or
disable compute allocation.

Default is \code{Enabled}.}

\item{Tags}{Tags of the compute allocation definition.}
}
\description{
Create compute allocation definition. This defines how compute is allocated, shared, and borrowed for specified entities. Specifically, how to lend and borrow idle compute and assign a fair-share weight to the specified entities.

See \url{https://www.paws-r-sdk.com/docs/sagemaker_create_compute_quota/} for full documentation.
}
\keyword{internal}
