% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codeguruprofiler_operations.R
\name{codeguruprofiler_list_profile_times}
\alias{codeguruprofiler_list_profile_times}
\title{Lists the start times of the available aggregated profiles of a
profiling group for an aggregation period within the specified time
range}
\usage{
codeguruprofiler_list_profile_times(
  endTime,
  maxResults = NULL,
  nextToken = NULL,
  orderBy = NULL,
  period,
  profilingGroupName,
  startTime
)
}
\arguments{
\item{endTime}{[required] The end time of the time range from which to list the profiles.}

\item{maxResults}{The maximum number of profile time results returned by
\code{\link[=codeguruprofiler_list_profile_times]{list_profile_times}} in paginated
output. When this parameter is used,
\code{\link[=codeguruprofiler_list_profile_times]{list_profile_times}} only returns
\code{maxResults} results in a single page with a \code{nextToken} response
element. The remaining results of the initial request can be seen by
sending another
\code{\link[=codeguruprofiler_list_profile_times]{list_profile_times}} request with
the returned \code{nextToken} value.}

\item{nextToken}{The \code{nextToken} value returned from a previous paginated
\code{\link[=codeguruprofiler_list_profile_times]{list_profile_times}} request
where \code{maxResults} was used and the results exceeded the value of that
parameter. Pagination continues from the end of the previous results
that returned the \code{nextToken} value.

This token should be treated as an opaque identifier that is only used
to retrieve the next items in a list and not for other programmatic
purposes.}

\item{orderBy}{The order (ascending or descending by start time of the profile) to use
when listing profiles. Defaults to \code{TIMESTAMP_DESCENDING}.}

\item{period}{[required] The aggregation period. This specifies the period during which an
aggregation profile collects posted agent profiles for a profiling
group. There are 3 valid values.
\itemize{
\item \code{P1D} — 1 day
\item \code{PT1H} — 1 hour
\item \code{PT5M} — 5 minutes
}}

\item{profilingGroupName}{[required] The name of the profiling group.}

\item{startTime}{[required] The start time of the time range from which to list the profiles.}
}
\description{
Lists the start times of the available aggregated profiles of a profiling group for an aggregation period within the specified time range.

See \url{https://www.paws-r-sdk.com/docs/codeguruprofiler_list_profile_times/} for full documentation.
}
\keyword{internal}
