% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codeconnections_operations.R
\name{codeconnections_create_repository_link}
\alias{codeconnections_create_repository_link}
\title{Creates a link to a specified external Git repository}
\usage{
codeconnections_create_repository_link(
  ConnectionArn,
  OwnerId,
  RepositoryName,
  EncryptionKeyArn = NULL,
  Tags = NULL
)
}
\arguments{
\item{ConnectionArn}{[required] The Amazon Resource Name (ARN) of the connection to be associated with
the repository link.}

\item{OwnerId}{[required] The owner ID for the repository associated with a specific sync
configuration, such as the owner ID in GitHub.}

\item{RepositoryName}{[required] The name of the repository to be associated with the repository link.}

\item{EncryptionKeyArn}{The Amazon Resource Name (ARN) encryption key for the repository to be
associated with the repository link.}

\item{Tags}{The tags for the repository to be associated with the repository link.}
}
\description{
Creates a link to a specified external Git repository. A repository link allows Git sync to monitor and sync changes to files in a specified Git repository.

See \url{https://www.paws-r-sdk.com/docs/codeconnections_create_repository_link/} for full documentation.
}
\keyword{internal}
