# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include costandusagereportservice_service.R
NULL

#' Deletes the specified report
#'
#' @description
#' Deletes the specified report. Any tags associated with the report are also deleted.
#'
#' See [https://www.paws-r-sdk.com/docs/costandusagereportservice_delete_report_definition/](https://www.paws-r-sdk.com/docs/costandusagereportservice_delete_report_definition/) for full documentation.
#'
#' @param ReportName &#91;required&#93; The name of the report that you want to delete. The name must be unique,
#' is case sensitive, and can't include spaces.
#'
#' @keywords internal
#'
#' @rdname costandusagereportservice_delete_report_definition
costandusagereportservice_delete_report_definition <- function(ReportName) {
  op <- new_operation(
    name = "DeleteReportDefinition",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .costandusagereportservice$delete_report_definition_input(ReportName = ReportName)
  output <- .costandusagereportservice$delete_report_definition_output()
  config <- get_config()
  svc <- .costandusagereportservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.costandusagereportservice$operations$delete_report_definition <- costandusagereportservice_delete_report_definition

#' Lists the Amazon Web Services Cost and Usage Report available to this
#' account
#'
#' @description
#' Lists the Amazon Web Services Cost and Usage Report available to this account.
#'
#' See [https://www.paws-r-sdk.com/docs/costandusagereportservice_describe_report_definitions/](https://www.paws-r-sdk.com/docs/costandusagereportservice_describe_report_definitions/) for full documentation.
#'
#' @param MaxResults 
#' @param NextToken 
#'
#' @keywords internal
#'
#' @rdname costandusagereportservice_describe_report_definitions
costandusagereportservice_describe_report_definitions <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeReportDefinitions",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "ReportDefinitions"),
    stream_api = FALSE
  )
  input <- .costandusagereportservice$describe_report_definitions_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .costandusagereportservice$describe_report_definitions_output()
  config <- get_config()
  svc <- .costandusagereportservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.costandusagereportservice$operations$describe_report_definitions <- costandusagereportservice_describe_report_definitions

#' Lists the tags associated with the specified report definition
#'
#' @description
#' Lists the tags associated with the specified report definition.
#'
#' See [https://www.paws-r-sdk.com/docs/costandusagereportservice_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/costandusagereportservice_list_tags_for_resource/) for full documentation.
#'
#' @param ReportName &#91;required&#93; The report name of the report definition that tags are to be returned
#' for.
#'
#' @keywords internal
#'
#' @rdname costandusagereportservice_list_tags_for_resource
costandusagereportservice_list_tags_for_resource <- function(ReportName) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .costandusagereportservice$list_tags_for_resource_input(ReportName = ReportName)
  output <- .costandusagereportservice$list_tags_for_resource_output()
  config <- get_config()
  svc <- .costandusagereportservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.costandusagereportservice$operations$list_tags_for_resource <- costandusagereportservice_list_tags_for_resource

#' Allows you to programmatically update your report preferences
#'
#' @description
#' Allows you to programmatically update your report preferences.
#'
#' See [https://www.paws-r-sdk.com/docs/costandusagereportservice_modify_report_definition/](https://www.paws-r-sdk.com/docs/costandusagereportservice_modify_report_definition/) for full documentation.
#'
#' @param ReportName &#91;required&#93; 
#' @param ReportDefinition &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname costandusagereportservice_modify_report_definition
costandusagereportservice_modify_report_definition <- function(ReportName, ReportDefinition) {
  op <- new_operation(
    name = "ModifyReportDefinition",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .costandusagereportservice$modify_report_definition_input(ReportName = ReportName, ReportDefinition = ReportDefinition)
  output <- .costandusagereportservice$modify_report_definition_output()
  config <- get_config()
  svc <- .costandusagereportservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.costandusagereportservice$operations$modify_report_definition <- costandusagereportservice_modify_report_definition

#' Creates a new report using the description that you provide
#'
#' @description
#' Creates a new report using the description that you provide.
#'
#' See [https://www.paws-r-sdk.com/docs/costandusagereportservice_put_report_definition/](https://www.paws-r-sdk.com/docs/costandusagereportservice_put_report_definition/) for full documentation.
#'
#' @param ReportDefinition &#91;required&#93; Represents the output of the PutReportDefinition operation. The content
#' consists of the detailed metadata and data file information.
#' @param Tags The tags to be assigned to the report definition resource.
#'
#' @keywords internal
#'
#' @rdname costandusagereportservice_put_report_definition
costandusagereportservice_put_report_definition <- function(ReportDefinition, Tags = NULL) {
  op <- new_operation(
    name = "PutReportDefinition",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .costandusagereportservice$put_report_definition_input(ReportDefinition = ReportDefinition, Tags = Tags)
  output <- .costandusagereportservice$put_report_definition_output()
  config <- get_config()
  svc <- .costandusagereportservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.costandusagereportservice$operations$put_report_definition <- costandusagereportservice_put_report_definition

#' Associates a set of tags with a report definition
#'
#' @description
#' Associates a set of tags with a report definition.
#'
#' See [https://www.paws-r-sdk.com/docs/costandusagereportservice_tag_resource/](https://www.paws-r-sdk.com/docs/costandusagereportservice_tag_resource/) for full documentation.
#'
#' @param ReportName &#91;required&#93; The report name of the report definition that tags are to be associated
#' with.
#' @param Tags &#91;required&#93; The tags to be assigned to the report definition resource.
#'
#' @keywords internal
#'
#' @rdname costandusagereportservice_tag_resource
costandusagereportservice_tag_resource <- function(ReportName, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .costandusagereportservice$tag_resource_input(ReportName = ReportName, Tags = Tags)
  output <- .costandusagereportservice$tag_resource_output()
  config <- get_config()
  svc <- .costandusagereportservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.costandusagereportservice$operations$tag_resource <- costandusagereportservice_tag_resource

#' Disassociates a set of tags from a report definition
#'
#' @description
#' Disassociates a set of tags from a report definition.
#'
#' See [https://www.paws-r-sdk.com/docs/costandusagereportservice_untag_resource/](https://www.paws-r-sdk.com/docs/costandusagereportservice_untag_resource/) for full documentation.
#'
#' @param ReportName &#91;required&#93; The report name of the report definition that tags are to be
#' disassociated from.
#' @param TagKeys &#91;required&#93; The tags to be disassociated from the report definition resource.
#'
#' @keywords internal
#'
#' @rdname costandusagereportservice_untag_resource
costandusagereportservice_untag_resource <- function(ReportName, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .costandusagereportservice$untag_resource_input(ReportName = ReportName, TagKeys = TagKeys)
  output <- .costandusagereportservice$untag_resource_output()
  config <- get_config()
  svc <- .costandusagereportservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.costandusagereportservice$operations$untag_resource <- costandusagereportservice_untag_resource
