% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{populate}
\alias{populate}
\title{Populate a list with data from another list}
\usage{
populate(input, interface, parent = NULL)
}
\arguments{
\item{input}{A list with data to copy.}

\item{interface}{A list of a similar shape to copy data into.}

\item{parent}{Internal parameter used to track parent interface for recursive structures.}
}
\description{
\code{populate} copies data from a list (e.g. input by a user) to another list
with a similar shape. The second list, called the \code{interface}, will generally
also contain extra metadata for making API requests, such as names or types.
}
\examples{
# Make an interface with metadata, e.g. type.
interface <- tag_add(list(foo = c(), bar = c()), list(type = "structure"))

# Combine data and the metadata from the interface.
populate(list(foo = 1, bar = 2), interface)

}
