% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arguments.R
\name{min_cols}
\alias{min_cols}
\alias{min_rows}
\title{Execution-time data dimension checks}
\usage{
min_cols(num_cols, source)

min_rows(num_rows, source, offset = 0)
}
\arguments{
\item{num_cols, num_rows}{The parameter value requested by the user.}

\item{source}{A data frame for the data to be used in the fit. If the source
is named "data", it is assumed that one column of the data corresponds to
an outcome (and is subtracted off).}

\item{offset}{A number subtracted off of the number of rows available in the
data.}
}
\value{
An integer (and perhaps a warning).
}
\description{
For some tuning parameters, the range of values depend on the data
dimensions (e.g. \code{mtry}). Some packages will fail if the parameter values are
outside of these ranges. Since the model might receive resampled versions of
the data, these ranges can't be set prior to the point where the model is
fit.  These functions check the possible range of the data and adjust them
if needed (with a warning).
}
\examples{
\dontshow{if (!parsnip:::is_cran_check() & rlang::is_installed("kknn")  & rlang::is_installed("ranger")) withAutoprint(\{ # examplesIf}
nearest_neighbor(neighbors= 100) |>
  set_engine("kknn") |>
  set_mode("regression") |>
  translate()

library(ranger)
rand_forest(mtry = 2, min_n = 100, trees = 3) |>
  set_engine("ranger") |>
  set_mode("regression") |>
  fit(mpg ~ ., data = mtcars)
\dontshow{\}) # examplesIf}
}
