% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strategy-class.R
\name{strategy-class}
\alias{strategy-class}
\title{Strategy class and subclasses}
\description{
The \code{strategy} class is a virtual class that defines the statistical approach
for population adjustment in indirect treatment comparisons
These objects are constructors that validate hyperparameters and encapsulate
modelling settings before execution by \code{\link[=outstandR]{outstandR()}}
}
\details{
Objects of class \code{strategy} have a common structure but carry
different subclasses to trigger specific S3 method dispatch

\describe{
\item{General fields}{Shared by all strategies:
\itemize{
\item \code{formula}: The linear regression formula for the outcome model
\item \code{family}: A base R family object specifying the distribution and link
\item \code{trt_var}: The name of the treatment variable.
}
}
\item{maic subclass}{Additional fields for Matching-Adjusted Indirect Comparison:
\itemize{
\item \code{n_boot}: Number of bootstrap resamples for variance estimation.
}
}
\item{stc subclass}{Additional fields for Simulated Treatment Comparison:
\itemize{
\item \code{N}: Synthetic sample size for the target population.
}
}
\item{gcomp_ml subclass}{Additional fields for Maximum Likelihood G-computation:
\itemize{
\item \code{rho}: Named square matrix of covariate correlations.
\item \code{marginal_distns}: Names of the marginal distributions for covariates.
\item \code{marginal_params}: Parameters for the marginal distributions.
\item \code{N}: Synthetic sample size for the pseudo-population.
\item \code{n_boot}: Number of bootstrap resamples.
}
}
\item{gcomp_bayes subclass}{Additional fields for Bayesian G-computation:
\itemize{
\item \code{rho}, \code{marginal_distns}, \code{marginal_params}, \code{N}: Same as \code{gcomp_ml}.
\item \code{...}: Additional arguments passed to the Stan engine via \code{rstanarm::stan_glm()}.
}
}
\item{mim subclass}{Additional fields for Multiple Imputation Marginalization:
\itemize{
\item \code{rho}: Correlation matrix.
\item \code{N}: Number of iterations/simulated individuals.
}
}
}
}
