% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tracer-provider-noop.R
\name{otel_tracer_provider}
\alias{otel_tracer_provider}
\title{OpenTelemetry Tracer Provider Object}
\value{
Not applicable.
}
\description{
\link{otel_tracer_provider} -> \link{otel_tracer} -> \link{otel_span} -> \link{otel_span_context}
}
\details{
The tracer provider defines how traces are exported when collecting
telemetry data. It is unlikely that you'd need to use tracer provider
objects directly.

Usually there is a single tracer provider for an R app or script.

Typically the tracer provider is created automatically, at the first
\code{\link[=start_local_active_span]{start_local_active_span()}} or \code{\link[=start_span]{start_span()}} call. otel decides which
tracer provider class to use based on \link{Environment Variables}.
}
\section{Implementations}{
Note that this list is updated manually and may be incomplete.
\itemize{
\item \link{tracer_provider_noop}: No-op tracer provider, used when no traces are
emitted.
\item \link[otelsdk:tracer_provider_file]{otelsdk::tracer_provider_file}: Save traces to a JSONL file.
\item \link[otelsdk:tracer_provider_http]{otelsdk::tracer_provider_http}: Send traces to a collector over
HTTP/OTLP.
\item \link[otelsdk:tracer_provider_memory]{otelsdk::tracer_provider_memory}: Collect emitted traces in memory.
For testing.
\item \link[otelsdk:tracer_provider_stdstream]{otelsdk::tracer_provider_stdstream}: Write traces to standard output
or error or to a file. Primarily for debugging.
}
}

\section{Methods}{
\subsection{\code{tracer_provider$get_tracer()}}{

Get or create a new tracer object.
\subsection{Usage}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{tracer_provider$get_tracer(
  name = NULL,
  version = NULL,
  schema_url = NULL,
  attributes = NULL
)
}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\itemize{
\item \code{name}: Tracer name, see \code{\link[=get_tracer]{get_tracer()}}.
\item \code{version}: Optional. Specifies the version of the instrumentation
scope if the scope has a version (e.g. R package version).
Example value: \code{"1.0.0"}.
\item \code{schema_url}: Optional. Specifies the Schema URL that should be
recorded in the emitted telemetry.
\item \code{attributes}: Optional. Specifies the instrumentation scope
attributes to associate with emitted telemetry. See \code{\link[=as_attributes]{as_attributes()}}
for allowed values. You can also use \code{\link[=as_attributes]{as_attributes()}} to convert R
objects to OpenTelemetry attributes.
}
}

\subsection{Value}{

Returns an OpenTelemetry tracer (\link{otel_tracer}) object.
}

\subsection{See also}{

\code{\link[=get_default_tracer_provider]{get_default_tracer_provider()}}, \code{\link[=get_tracer]{get_tracer()}}.
}

}

\subsection{\code{tracer_provider$flush()}}{

Force any buffered spans to flush. Tracer providers might not implement
this method.
\subsection{Usage}{

\if{html}{\out{<div class="sourceCode">}}\preformatted{tracer_provider$flush()
}\if{html}{\out{</div>}}
}

\subsection{Value}{

Nothing.
}

}
}

\examples{
tp <- otel::get_default_tracer_provider()
trc <- tp$get_tracer()
trc$is_enabled()
}
\seealso{
Other low level trace API: 
\code{\link{get_default_tracer_provider}()},
\code{\link{get_tracer}()},
\code{\link{otel_span}},
\code{\link{otel_span_context}},
\code{\link{otel_tracer}},
\code{\link{tracer_provider_noop}}
}
\concept{low level trace API}
