% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lobato_test.R
\name{lobato_bootstrap.test}
\alias{lobato_bootstrap.test}
\title{The Sieve Bootstrap Lobato and Velasco's Test for normality.}
\usage{
lobato_bootstrap.test(y, c = 1, reps = 1000, h = 100, seed = NULL)
}
\arguments{
\item{y}{a numeric vector or an object of the \code{ts} class containing a stationary
time series.}

\item{c}{a positive real value that identifies the total amount of values used in the
cumulative sum.}

\item{reps}{an integer with the total bootstrap repetitions.}

\item{h}{an integer with the first \code{burn-in} sieve bootstrap replicates.}

\item{seed}{An optional \code{\link[=set.seed]{seed}} to use.}
}
\value{
A list with class \code{"h.test"} containing the following components:
 \item{statistic:}{the sieve bootstrap Lobato  n Velasco's statistic.}
 \item{p.value:}{the p value for the test.}
 \item{alternative:}{a character string describing the alternative hypothesis.}
 \item{method:}{a character string \dQuote{Sieve-Bootstrap Lobato's test}.}
 \item{data.name:}{a character string giving the name of the data.}
}
\description{
Performs the approximated Lobato and Velasco's test of normality for univariate time series.
Computes the p-value using Psaradakis and Vavra's (2020) sieve bootstrap procedure.
}
\details{
This test proves a normality assumption in correlated data employing the
skewness-kurtosis test statistic proposed by \emph{Lobato, I., & Velasco, C. (2004)},
approximating the p-value using a sieve-bootstrap procedure,
\emph{Psaradakis, Z. and Vávra, M. (2020)}.
}
\examples{
# Generating an stationary arma process
y = arima.sim(1000,model = list(ar = 0.3))
lobato_bootstrap.test(y, reps = 1000)

}
\references{
Psaradakis, Z. and Vávra, M. (2020) Normality tests for dependent
data: large-sample and bootstrap approaches. Communications in
\emph{Statistics-Simulation and Computation 49 (2)}. ISSN 0361-0918.

Nieto-Reyes, A., Cuesta-Albertos, J. & Gamboa, F. (2014). A random-projection
based test of Gaussianity for stationary processes. \emph{Computational
Statistics & Data Analysis, Elsevier}, vol. 75(C), pages 124-141.

Lobato, I., & Velasco, C. (2004). A simple test of normality in time series.
\emph{Journal of econometric theory}. 20(4), 671-689.
}
\seealso{
\code{\link{lobato.statistic}},\code{\link{epps.test}}
}
\author{
Asael Alonzo Matamoros and Alicia Nieto-Reyes.
}
